/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/haqM
 */

package  {
    
    import flash.display.*;
    import flash.events.*;
    
    import idv.cjcat.stardust.common.actions.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.common.emitters.*;
    import idv.cjcat.stardust.common.renderers.*;
    import idv.cjcat.stardust.common.initializers.*;
    import idv.cjcat.stardust.common.math.*;
    import idv.cjcat.stardust.twoD.actions.*;
    import idv.cjcat.stardust.twoD.initializers.*;
    import idv.cjcat.stardust.twoD.emitters.*;
    import idv.cjcat.stardust.twoD.zones.*;
    import idv.cjcat.stardust.twoD.renderers.*;
    
    
    public class Star extends Sprite {
        private var emitter:Emitter2D;
        private var renderer:Renderer;

        public function Star() {
            init();
        }
        
        private function init():void{
            var mc:MovieClip = new MovieClip();
            mc.x = mc.y = 200;
            addChild(mc);
            
            //パーティクルシステムの構築
            //[1]clockを作成
            //1ステップに発生させたい数値を指定
            var clock:SteadyClock = new SteadyClock(1);
            
            //[2]エミッターを作成
            emitter = new Emitter2D(clock);
            
            //[3]レンダーを作成
            renderer = new DisplayObjectRenderer(mc);
            
            //[4]レンダーにエミッターを追加
            renderer.addEmitter(emitter);
            
            
            //[5]イニシャレイザーを登録
            //パーティクルのアイテムを指定
            emitter.addInitializer(new DisplayObjectClass(MyCircle));
            //パーティクルにかかる力を指定
            emitter.addInitializer(new Velocity(new LazySectorZone(0.1, 0)));
            //パーティクルのライフを指定
            emitter.addInitializer(new Life(new UniformRandom(50, 0)));
            emitter.addInitializer(new Position(new Line(-130, 300, 50, 50)));
            
            //[6]アクションを登録
            emitter.addAction(new Age());
            emitter.addAction(new DeathLife());
            emitter.addAction(new Accelerate(0.5));
            emitter.addAction(new Move());
            
            addEventListener(Event.ENTER_FRAME, loop);                                   
        }
        private function loop(e:Event):void{
            emitter.step(); //[7]エミッターの更新
        }

    }
    
}

//円(プライベートクラス)
import flash.display.*;
class MyCircle extends Sprite{
    public function MyCircle(){
        graphics.beginFill(Math.random() * 0xffffff);
        graphics.drawCircle(0, 0, 10);
        graphics.endFill();
    }
}