/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/habZ
 */

package {
    import flash.display.Sprite;
   import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.Point;
    
    import flash.display.Shape;
    import flash.geom.Matrix;
    
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.InterpolationMethod;
    
    public class FlashTest extends Sprite
    {
    		public var wb_sh:Shape = new Shape();
    		public var wb_mt:Matrix = new Matrix();
    		
    		public var perlin_sp:Sprite = new Sprite();
    		public var perlin_bp:Bitmap;
    		public var perlin_bmd:BitmapData;
    		
    		public const STAGE_SCALE:int = 1;
    		public const STAGE_WIDTH:int = stage.stageWidth / STAGE_SCALE;
    		public const STAGE_HEIGHT:int = stage.stageHeight / STAGE_SCALE;
    		
        public function FlashTest()
        {
        		init();
        }
        public function init():void
        {
        		wb_mt.createGradientBox(stage.stageWidth, stage.stageHeight , Math.PI/2, 0, 0);
        		wb_sh.graphics.beginGradientFill(
        			GradientType.LINEAR,
        			[0xffffff, 0x000000],
        			[1, 1],
        			[0, 255],
        			wb_mt,
        			SpreadMethod.PAD,
        			InterpolationMethod.LINEAR_RGB,
        			0
        		);
        		wb_sh.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        		addChild(wb_sh);
        		
        		perlin_bmd = new BitmapData(
        			STAGE_WIDTH,
        			STAGE_HEIGHT,
        			false,
        			0xffffff
        		);
        		perlin_bp = new Bitmap();
        		perlin_bp.bitmapData = perlin_bmd;
        		perlin_bp.scaleX = perlin_bp.scaleY = STAGE_SCALE + .1; 
        		perlin_sp.addChild(perlin_bp);
        		stage.addChild(perlin_sp);
        		perlin_sp.blendMode = BlendMode.MULTIPLY;
        		
        		stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        public const BASE_X:int = stage.stageWidth / 6;
        public const BASE_Y:int = stage.stageHeight;
        
        public const OCTAVE_NUMBER:uint = 1;
        public var RANDOM_SEED:int = Math.floor(Math.random() * 0xffffff);
        public var CHANNEL_OPTION:int = 7;//BitmapDataChannel.RED |BitmapDataChannel.BLUE;//7;
        public var offset_array:Array = [new Point(),new Point(), new Point()];
        
        public function onEnterFrame(evt:Event):void
        {
        		perlin_bmd.perlinNoise(
        			BASE_X,
        			BASE_Y,
        			OCTAVE_NUMBER,
        			RANDOM_SEED,
        			true,
        			false,
        			CHANNEL_OPTION,
        			false,
        			offset_array
        		);
        		offset_array[0].y += 1;
        		offset_array[1].x -= 20;
        		offset_array[2].y -= 0;
        		
        }
    }
}