/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/haVb
 */

// forked from uwi's forked from: 輪廻転生（Metempsychosis）
// forked from mousepancyo's 輪廻転生（Metempsychosis）
package{
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import net.hires.debug.Stats;
    
    [SWF(width=465, height=465, backgroundColor=0, frameRate=60)]
    
    public class Main extends Sprite{
        private const W:int = 465;
        private const H:int = 465;
        
        private var _pointList:Vector.<Point>;
        private var _pointNum:Number = 1000;
        private var _count:Number = 0;
        private var _circleBmd:BitmapData;
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        private var _copyBmd:BitmapData;
        private var _copyBm:Bitmap;
        private var _ct:ColorTransform;
        private var _particleList:Array;
        
        public function Main(){
            graphics.beginFill(0)
            graphics.drawRect(0, 0, W, H)
            graphics.endFill()
            //
            _circleBmd = new BitmapData(100, 100, true, 0);
            _bmd = new BitmapData(465, 465, false, 0);
            _ct = new ColorTransform(.9, .9, .9, 1);
            _pointList = new Vector.<Point>;
            //
            setup()
            addChild(_bm);
            addChild(_copyBm);
            addEventListener(Event.ENTER_FRAME, draw);
            addChild(new Stats());
            
            _particleLayer = new BitmapData(465, 465, true, 0x00000000);
            addChild(new Bitmap(_particleLayer));
        }
        
        private function setup():void{
            var circle:Circle = new Circle(12, 50);
            circle.filters = [new GlowFilter(0xFFFFFF, 1, 10, 10, 1, 3, false, true)];
            _circleBmd.draw(circle);
            
            for(var i:Number = 0; i < _pointNum; i++){
                var p:Point = new Point();
                _pointList.push(new Point());
                var r:Number = i * 2 * Math.PI * ((1 + Math.sqrt(6)) / 2);
                _pointList[i].x = W / 2 + (i * .3) * Math.cos(r);
                _pointList[i].y = H / 2 + (i * .3) * Math.sin(r);
            }
            
            _bm = new Bitmap(_bmd, "auto", true)
            _copyBmd = _bmd.clone();
            _copyBm = new Bitmap(_copyBmd);
            _copyBm.blendMode = "multiply";
        }
        
        private function draw(e:Event):void{
            if(_count >= _pointNum){
                createPeace();
                _count = 0;
            }else{
                _copyBmd.lock();
                _copyBmd.copyPixels(_bmd, _bmd.rect, new Point());
                _bmd.lock();
                _bmd.copyPixels(_circleBmd, _circleBmd.rect, new Point(_pointList[_count].x-50, _pointList[_count].y-50));
                _bmd.colorTransform(_bmd.rect, _ct);
                _copyBmd.unlock();
                _bmd.unlock();
                _count++;
            }
            colorChange();
        }
        
        private function colorChange():void{
            (_ct.redMultiplier > 1.01)? _ct.redMultiplier = (Math.random() * .05 + .987) : _ct.redMultiplier += .001;
            (_ct.greenMultiplier > 1.01)? _ct.greenMultiplier = (Math.random() * .05 + .987) : _ct.greenMultiplier += .001;
            (_ct.blueMultiplier > 1.01)? _ct.blueMultiplier = (Math.random() * .05 + .987) : _ct.blueMultiplier += .001;
        }
        
        //Break
        private function createPeace():void{
            _original = _bmd.clone();
//            var image:BitmapData = _bmd.clone();
//            _particleList = new Vector.<Particle>;
//            _particleBmdList = new Vector.<BitmapData>;
            //
            _particleList = [];
            for(var i:int=0; i<93; i++){
                for(var j:int=0; j<93; j++){
                    var radius:Number = Math.sqrt(Math.random()) * 10;
                    var angle:Number = Math.random() * (Math.PI) * 2;
                    var p : Object = {
                        p : new Point(j * 5, i * 5),
                        rect : new Rectangle(j * 5, i * 5, 5, 5),
                        vx : Math.cos(angle) * radius,
                        vy : Math.sin(angle) * radius
                    };
                    //
                    _particleList.push(p);
                }
            }
            //
//            image.dispose()
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private var _particleLayer : BitmapData;
        private var _original : BitmapData;
        
        private function update(e:Event):void{
            _bmd.lock();
            _bmd.colorTransform(_bmd.rect, new ColorTransform(.99, .99, .99))
            _bmd.unlock();
            // 
            
            if(_particleList.length > 0){
                _particleLayer.lock();
                _particleLayer.fillRect(_particleLayer.rect, 0);
                var n:int = _particleList.length;
                while (n--) {
                    var v:Number = Math.random() * .5 + .8;
                    var p:Object = _particleList[n];
                    p.vy += .5;
                    p.vx *= v * .95;
                    p.vy *= v;
                    p.p.x += p.vx;
                    p.p.y += p.vy; 
                    
                    _particleLayer.copyPixels(_original, p.rect, p.p);
                    //
                    if(p.p.x < -50 || p.p.x > W + 50 || p.p.y < -100 || p.p.y > H * 1.2){
    //                    removeChild(_particleList[n]);
    //                    _particleBmdList[n].dispose();
    //                    _particleList[n] = null
//                        _particleList.splice(n, 1);
                        if(n == _particleList.length - 1){
                            _particleList.pop();
                        }else{
                            _particleList[n] = _particleList.pop();
                        }

                        if(_particleList.length == 0){
                            removeEventListener(Event.ENTER_FRAME, update);
                            _original.dispose();
                        }
                    }
                }
                _particleLayer.unlock();
            }
        }
    }
}


//Circle
import flash.display.Sprite;
import flash.display.Shape;

class Circle extends Sprite{
    
    public function Circle(r:int, ofset:int){
        var sp:Shape = new Shape();
        sp.x = ofset;
        sp.y = ofset;
        addChild(sp);
        sp.graphics.beginFill(0xFFFFFF);
        sp.graphics.drawCircle(0,0,r);
        sp.graphics.endFill();
    }
}

//Particle
import flash.display.Bitmap;
import flash.display.BitmapData;

class Particle extends Bitmap{
    
    public var homeX:Number = 0;
    public var homeY:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Particle(bmd:BitmapData, snap:String = "auto", somooth:Boolean = false){
        super(bmd, snap, somooth);
    }
}