/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/haKF
 */

// forked from bkzen's 【問題】Graphics の drawCircle と drawRoundRect が壊れました
package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	
        import flash.display.Bitmap;
        import flash.display.BitmapData;
        import flash.geom.Point;

	/**
	 * Graphics.drawCircle と drawRoundRect が壊れました。
	 * 別の方法で、半径 CIRCLE_RADIUS の 円を書きなさい。
	 * @mxmlc -o bin/CircleTest.swf -load-config+=obj\Alltest3Config.xml
	 * @author jc at bk-zen.com
	 */
	public class CircleTest extends Sprite
	{
		private const ANSWER_COLOR: uint = 0x003366;
		private const COLOR: uint = 0x3399CC;
		private const CIRCLE_RADIUS: Number = 50;
		
		public function CircleTest() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
			var centerX: Number = (stage.stageWidth - CIRCLE_RADIUS) / 2;
			var centerY: Number = (stage.stageHeight - CIRCLE_RADIUS) / 2;
			var g: Graphics = graphics;
			// 差を見るために解答として先に半径+1 の円を描いておきます。
			g.beginFill(ANSWER_COLOR); g.drawCircle(centerX, centerY, CIRCLE_RADIUS + 1);
			
			// 
			drawCircle(g, centerX, centerY, CIRCLE_RADIUS, COLOR);
		}
		
		/**
		 * 中心点から距離r以内の点を打ちまくるだけ。
                 * 引数のg…？知らないなぁ…
		 * @param	g
		 * @param	x
		 * @param	y
		 * @param	r
		 * @param	color
		 */
		public function drawCircle(g: Graphics, x: Number, y: Number, r: Number, color: uint): void
		{
			
                        var bitmapData:BitmapData = new BitmapData(r*2,r*2,true,0x00ffffff);
                        var bitmap:Bitmap = new Bitmap(bitmapData);
                        
                        bitmap.x = x - r;
                        bitmap.y = y - r;
                        
                        addChild(bitmap);
                        
                        bitmapData.lock();
                        
                        //ここどのくらいの数にするのが適切なのだろう…
                        var dots:int = r*2 * r*2 * r;
                        for(var i:int = 0;i < dots;i++){
                            var point:Point = Point.polar(r * Math.random(), 2 * Math.PI * Math.random())
                            bitmapData.setPixel32(r + point.x, r + point.y, 0xff000000|color);
                        }
                        bitmapData.unlock();
                        
		}
		
	}

}