/**
 * Copyright northprint ( http://wonderfl.net/user/northprint )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hZTE
 */

/*ベーシックなProgression4のコード?*/
/*赤がSceneAで緑がSceneBで青がSceneC*/
/*NextButtonとPreviousButtonのつかいかたとか*/
/*TextField毎回作ってるけど、これも使いまわしで良いね。まあ、サンプルということで*/
package {
    import flash.display.*;
    import jp.progression.config.*;
    import jp.progression.debug.*;
    import jp.progression.*;
    
    public class Index extends Sprite {
        
        public var manager:Progression;
        
        public function Index() {
            Progression.initialize( new BasicAppConfig() );
            manager = new Progression( "index", stage, IndexScene );
         
            manager.goto( manager.root.sceneId );
        }
    }
}


import flash.net.*;
import flash.system.*;
import flash.text.TextField;
import jp.progression.casts.*;
import jp.progression.casts.buttons.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.managers.Goto;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;
import flash.events.MouseEvent;


class IndexScene extends SceneObject {
    
    public function IndexScene() {
    }
    
    protected override function atSceneLoad():void {
		
		var sceneA:InfoScene = new InfoScene("SceneA");
		var sceneB:InfoScene = new InfoScene("SceneB");
		var sceneC:InfoScene = new InfoScene("SceneC");
		
		addScene(sceneA);
		addScene(sceneB);
		addScene(sceneC);
		
		var prevButton:ExPreviousButton = new ExPreviousButton( { x:50, y:50 } );
		var nextButton:ExNextButton = new ExNextButton( { x:420, y:50 } );
		prevButton.managerId = "index";
		nextButton.managerId = "index";
		prevButton.useTurnBack = true;
		nextButton.useTurnBack = true;
		
		var sceneChangeButton1:SceneChangeButton = new SceneChangeButton(0xff0000, { x:40, y:420 } );
		var sceneChangeButton2:SceneChangeButton = new SceneChangeButton(0x00ff00, { x:220, y:420 } );
		var sceneChangeButton3:SceneChangeButton = new SceneChangeButton(0x0000ff, { x:400, y:420 } );
		
		sceneChangeButton1.sceneId = sceneA.sceneId;
		sceneChangeButton2.sceneId = sceneB.sceneId;
		sceneChangeButton3.sceneId = sceneC.sceneId;
		
		var buttonBase:CastSprite = new CastSprite();
        var backContainer:BackContainer = new BackContainer( { id:"background" } );
		
		addCommand(
			new AddChildAt(container, backContainer,0),
			[
			new AddChild(buttonBase, sceneChangeButton1),
			new AddChild(buttonBase, sceneChangeButton2),
			new AddChild(buttonBase, sceneChangeButton3),
			new AddChild(buttonBase, prevButton),
			new AddChild(buttonBase, nextButton)
			],
			new AddChildAt(container, buttonBase,1)
        );
    }
	protected override function atSceneInit():void {
		manager.goto(getSceneAt(0).sceneId);
	}
}

class BackContainer extends CastSprite {
	
	public function BackContainer(initObject:Object):void {
		super(initObject);
	}
	
	public function set color(value:uint):void {
		
		graphics.clear();
		graphics.beginFill(value);
		graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
		graphics.endFill();
	}
}

class InfoScene extends SceneObject {

	private var textField:TextField;
	
    public function InfoScene(name:String = null, initObject:Object = null) {
		super( name, initObject );
    }
    
    protected override function atSceneInit():void {
		textField = new TextField();
		textField.text = name;
		textField.x = stage.stageWidth / 2;
		textField.y = stage.stageHeight / 2;
		
		var backContainer:BackContainer = BackContainer( getInstanceById("background"));
		switch(name) {
			case "SceneA":
				backContainer.color = 0xff0000;
				break;
			case "SceneB":
				backContainer.color = 0x00ff00;
				break;
			case "SceneC":
				backContainer.color = 0x0000ff;
				break;
			default :
				backContainer.color = 0xffffff;
		}
		
		addCommand(
			new AddChild(container, textField)
		);
    }
    protected override function atSceneGoto():void {
		addCommand(
			new RemoveChild(container, textField)
		);
	}
}

class SceneChangeButton extends CastButton {
	public function SceneChangeButton(color:int = 0x000000,initObject:Object = null) {
		super(initObject);
		graphics.lineStyle(1, 0x000000);
		graphics.beginFill(color);
		graphics.drawRect(0, 0, 30, 30);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
	}
}

class ExNextButton extends NextButton {
	public function ExNextButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,-15);
		graphics.lineTo(0,-15);
		graphics.lineTo(0,-25);
		graphics.lineTo(25,0);
		graphics.lineTo(0,25);
		graphics.lineTo(0,15);
		graphics.lineTo(-25,15);
		graphics.lineTo(-25,-15);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
		
	}
}

class ExPreviousButton extends PreviousButton {
	public function ExPreviousButton(initObject:Object = null) {
		super(initObject);
		
		graphics.beginFill(0x000000);
		graphics.moveTo(-25,0);
		graphics.lineTo(0,-25);
		graphics.lineTo(0,-15);
		graphics.lineTo(25,-15);
		graphics.lineTo(25,15);
		graphics.lineTo(0,15);
		graphics.lineTo(0,25);
		graphics.lineTo(-25,0);
		graphics.endFill();
		
		buttonMode = true;
		useHandCursor = true;
	}
}