/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hZKh
 */

// forked from h6k's ライツアウト

package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	public class FlashTest extends Sprite {
		private var pos:Array = new Array(5);
		private var lights:Vector.<Vector.<Shape>> = new Vector.<Vector.<Shape>>();
		private var sw:int = stage.stageWidth;		// 全体サイズ
		private var sh:int = stage.stageHeight;
		private var fw:int = sw / 6 * 5;			// マスサイズ
		private var fh:int = sh / 6 * 5;
		private var ofx:int = (sw - fw) / 2;		// オフセット
		private var ofy:int = (sh - fh) / 2;
		
		private var sp:Sprite = new Sprite();
		private var fld:TextField = new TextField();
		private var btn:Sprite = new Sprite();
		
		public function FlashTest() {
			// write as3 code here..
			// 配列初期化
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(fw / 5, fh / 5, Math.PI);
			
			for (var X:int = 0; X < 5; X++) {
				pos[X] = [false, false, false, false, false];
				lights[X] = new Vector.<Shape>();
				
				for (var Y:int = 0; Y < 5; Y++) {
					var col1:uint = hsv2rgb((X + Y) / 13 * 360, 0.1, 1);
					var col2:uint = hsv2rgb((X + Y) / 13 * 360, 0.9, 1);
					lights[X][Y] = new Shape();
					lights[X][Y].graphics.beginGradientFill("radial", [col1, col2, 0], [1, 1, 0], [0, 160, 255], matrix);
					lights[X][Y].graphics.drawCircle(fw / 10, fh / 10, fw / 10);
					lights[X][Y].alpha = 0;
					lights[X][Y].x = ofx + fw / 5 * X;
					lights[X][Y].y = ofy + fh / 5 * Y;
					addChild(lights[X][Y]);
				}
			}
			loadStage();
		}
		
		// 配列から描画
		private function repaint():Boolean {
			var clear:Boolean = true;
			for (var X:int = 0; X < pos.length; X++) {
				for (var Y:int = 0; Y < pos[X].length; Y++) {
					if (pos[X][Y]) clear = false;
				}
			}
			return clear;
		}
		
		// ステージ作成
		private function loadStage():void {
			addChildAt(sp, 0);
			sp.graphics.beginFill(0, 1);
			sp.graphics.drawRect(0, 0, sw, sh);
			sp.graphics.endFill();
			sp.graphics.lineStyle(1, 0x999999);
			sp.graphics.drawRect(ofx, ofy, fw, fh);
			for (var i:int = 1; i < 5; i++) {
				sp.graphics.moveTo(ofx + fw / 5 * i, ofy);
				sp.graphics.lineTo(ofx + fw / 5 * i, ofy + fh);
				sp.graphics.moveTo(ofx             , ofy + fh / 5 * i);
				sp.graphics.lineTo(ofx + fw        , ofy + fh / 5 * i);
			}
			
			addChild(fld);
			fld.textColor = 0x999999;
			fld.x = ofx;
			fld.y = fh + ofy + 10;
			fld.width = fw;
			fld.border = true;
			fld.borderColor = 0x999999;
			fld.mouseEnabled = false;
			fld.autoSize = TextFieldAutoSize.CENTER;
			fld.text = "- PLAY! -";
			
			addChild(btn);
			btn.addChild(fld);
			btn.addEventListener(MouseEvent.CLICK, GameStart);
			
			addEventListener(Event.ENTER_FRAME, function(e:Event):void
			{
				for (var X:int = 0; X < 5; X++) {
					for (var Y:int = 0; Y < 5; Y++) {
						if (pos[X][Y]) lights[X][Y].alpha += lights[X][Y].alpha >= 1 ? 0 : 0.1;
						else lights[X][Y].alpha -= lights[X][Y].alpha <= 0 ? 0 : 0.1;
					}
				}
			});
		}
		
		// ゲームスタート
		private function GameStart(e:MouseEvent):void {
			// 配置
			for (var X:int = 0; X < 5; X++) {
				for (var Y:int = 0; Y < 5; Y++) {
					var r:int = Math.random() * 100;
					if (r % 2 == 0) {
						reposition(X, Y);
					}
				}
			}
			repaint();
			
			// クリックイベント
			fld.text = "- GIVE UP -";
			btn.removeEventListener(MouseEvent.CLICK, arguments.callee);
			btn.addEventListener(MouseEvent.CLICK, allClear);
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
		}
		
		// クリック
		private function onMouseClick(e:MouseEvent):void {
			var X:int = -1;
			var Y:int = -1;
			var i:int;
			
			// クリックした座標取得
			for (i = 0; i <= 5; i++) {
				if (mouseX < fw / 5 * i + ofx) {
					X = i - 1;
					break;
				}
			}
			for (i = 0; i <= 5; i++) {
				if (mouseY < fh / 5 * i + ofy) {
					Y = i - 1;
					break;
				}
			}
			if (X >= 0 && Y >= 0) {
				reposition(X, Y);
				if (repaint()) {
					// クリア
					fld.text = "CONGRATULATIONS! b(^_-)";
					stage.removeEventListener(MouseEvent.CLICK, arguments.callee);
					btn.addEventListener(MouseEvent.CLICK, allClear);
				}
			}
		}
		
		// 配列更新
		private function reposition(X:int, Y:int):void {
			// 押した場所
			pos[X][Y] = !pos[X][Y];
			// 上
			if (Y - 1 >= 0) {
				pos[X][Y - 1] = !pos[X][Y - 1];
			}
			// 右
			if (X + 1 < 5) {
				pos[X + 1][Y] = !pos[X + 1][Y];
			}
			// 下
			if (Y + 1 < 5) {
				pos[X][Y + 1] = !pos[X][Y + 1];
			}
			// 左
			if (X - 1 >= 0) {
				pos[X - 1][Y] = !pos[X - 1][Y];
			}
		}
		
		// 初期化
		private function allClear(e:MouseEvent):void {
			for (var X:int = 0; X < 5; X++) {
				pos[X] = [false, false, false, false, false];
			}
			repaint();
			
			// クリックイベント
			fld.text = "- PLAY! -";
			btn.removeEventListener(MouseEvent.CLICK, arguments.callee);
			btn.addEventListener(MouseEvent.CLICK, GameStart);
		}
		
		private function hsv2rgb(h:Number, s:Number, v:Number):uint
		{
			s = s > 1 ? 1 : (s < 0 ? 0 : s);
			v = v > 1 ? 1 : (v < 0 ? 0 : v);
			
			if (s == 0) return 0xFF * v << 16 | 0xFF * v << 8 | 0xFF * v << 0;
			
			h = h >= 360 ? h % 360 : (h < 0 ? h % 360 + 360 : h);
			
			var i:int = int(h / 60);
			var f:Number = h / 60 - i;
			var p:Number = v * (1 - s);
			var q:Number = v * (1 - s * f);
			var t:Number = v * (1 - s * (1 - f));
			
			switch (i) {
				case 0: return 0xFF * v << 16 | 0xFF * t << 8 | 0xFF * p << 0;
				case 1: return 0xFF * q << 16 | 0xFF * v << 8 | 0xFF * p << 0;
				case 2: return 0xFF * p << 16 | 0xFF * v << 8 | 0xFF * t << 0;
				case 3: return 0xFF * p << 16 | 0xFF * q << 8 | 0xFF * v << 0;
				case 4: return 0xFF * t << 16 | 0xFF * p << 8 | 0xFF * v << 0;
				case 5: return 0xFF * v << 16 | 0xFF * p << 8 | 0xFF * q << 0;
			}
			
			return 0;
		}
	}
}