/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hZIZ
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.media.*;

    [SWF(width="465", height="465", frameRate="30")]

    public class Test extends Sprite {

            private var camera:Camera;
            private var video:Video;
            private var display:BitmapData;
            private var frame:BitmapData;
            private var rect:Rectangle = new Rectangle();
            private var point:Point = new Point();
            private const BLOCK:int = 6;

            public function Test() {
                camera = Camera.getCamera();
                if (camera == null) return;
                camera.setMode(200, 200, 60);
                video = new Video(camera.width, camera.height);
                video.attachCamera(camera);

                display = new BitmapData(camera.width*3, camera.height*3, false);
                addChild(new Bitmap(display));
                frame = new BitmapData(camera.width, camera.height, false);

                rect.width = rect.height = BLOCK;

                addEventListener(Event.ENTER_FRAME, update);
            }

            private function update(e:Event):void {
                frame.draw(video);
                display.lock();
                for (var x:int = 0; x < frame.width; x += BLOCK) {
                    for (var y:int = 0; y < frame.height; y += BLOCK) {
                        rect.x = x;
                        rect.y = y;
                        for (var i:int = 0; i < 3; i++) {
                            for (var j:int = 0; j < 3; j++) {
                                point.x = x * 3 + i * BLOCK;
                                point.y = y * 3 + j * BLOCK;
                                display.copyPixels(frame, rect, point);
                            }
                        }
                    }
                }
                display.unlock();
            }
    }
}
