/**
 * Copyright ryosuke.balboa ( http://wonderfl.net/user/ryosuke.balboa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hYgf
 */

// forked from Saqoosha's Snow
package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
        import net.hires.debug.Stats;

    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=120)]

    public class Saq001 extends Sprite {
        
        private static const GRAVITY:Number = 20;
        private static const DRAG:Number = 0.3;
        
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _glowMtx:Matrix;
        private var _forceMap:BitmapData;
        private var _snow:Array;
        
        public function Saq001() {
            this._canvas = new BitmapData(465, 465, false, 0x0); // カンバスをつくる。ここに 1 pixel ずつ描いていくよ
            this.addChild(new Bitmap(this._canvas)) as  Bitmap;  // stage に配置
            
            
            this._glow = new BitmapData(465 / 4, 465 / 4, false, 0x0); // キラキラを描く用のん。カンバスの 4 分の 1 のサイズ
            var bm:Bitmap = this.addChild(new Bitmap(this._glow, PixelSnapping.NEVER, true)) as Bitmap; // smoothing を true にして配置
            bm.scaleX = bm.scaleY = 4; // 4 倍にする。
            bm.blendMode = BlendMode.ADD; // 加算モードで合成
            this._glowMtx = new Matrix(0.25, 0, 0, 0.25);
            
            
            // 雪を積もらせるかたちを BitmapData に描く。
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat('Helvetica', 72, 0xffffff, true); 
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = 'Heavy Rain';
            tf.x = (465 - tf.width) / 2;
            tf.y = (465 - tf.height) / 2;
            this._forceMap = new BitmapData(465, 465, false, 0x0);
            this._forceMap.draw(tf, tf.transform.matrix);
            this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0, 0), new BlurFilter(8, 8));
            
            this._snow = []; // 雪パーティクルはここにいれておくよ。
            
                        this.addChild(new Stats());

            this.addEventListener(Event.ENTER_FRAME, this.update); // 毎フレーム update を呼ぶよ
        }
        
        // 雪を 1 粒発生させる関数
        public function emitParticle(ex:Number, ey:Number, s:Number = 1, c:int = 0xb0ffff, vx:Number = 0, vy:Number = 0):void {
            var p:SnowParticle = new SnowParticle(); // 作って
            // パラメータ設定して
            p.x = ex;
            p.y = ey;
            p.vx = vx;
            p.vy = vy;
            p.s = s;
            p.c = c;
            this._snow.push(p); // 保存
        }
        
        // 雪を動かすよーー
        public function update(e:Event):void {
            this._canvas.lock(); // いっぱい setPixel するときは必ず lock しよう
            this._canvas.fillRect(this._canvas.rect, 0x0); // カンバスをクリア
            var n:int = this._snow.length;
            var d:Number;
            var gravity:Number = GRAVITY / 1000; // あらかじめ計算しとく
            while (n--) {
                var p:SnowParticle = this._snow[n];
                p.vy += gravity * p.s; // まず重力を加える
                p.vx *= 0.99; // 空気抵抗
                p.vy *= 0.99; // y 方向にも
                d = 1 - (this._forceMap.getPixel(p.x, p.y) / 0xffffff) * DRAG; // forceMap にもとづいて抵抗値を計算。黒→速い、白→遅い。
                p.vx *= d; // forceMap から得た抵抗値を適用
                p.vy *= d; // y 方向にも
                
                //雨粒描画
                if(this._forceMap.getPixel(p.x, p.y) > 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-1) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-2) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-3) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-4) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-5) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-6) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-7) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-8) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-9) < 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-10) < 0x888888){ // 文字に接触し跳ね返る雨粒大
                    p.x += p.vx -0.02;
                    p.y += p.vy/1.5;
                    p.c = 0xffffff; 
                    
                    this._canvas.setPixel(p.x+5, p.y-3, p.c);
                    this._canvas.setPixel(p.x-5, p.y-3, p.c);
                    this._canvas.setPixel(p.x+3, p.y-5, p.c);
                    this._canvas.setPixel(p.x-3, p.y-5, p.c);
                    this._canvas.setPixel(p.x+1, p.y-6, p.c);
                    this._canvas.setPixel(p.x-1, p.y-6, p.c);
                }
                else if(this._forceMap.getPixel(p.x, p.y) > 0x888888 &&
                    this._forceMap.getPixel(p.x, p.y-1) < 0x888888){ // 文字に接触し跳ね返る雨粒小
                    p.x += p.vx -0.02;
                    p.y += p.vy/1.5;
                    p.c = 0xffffff; 

                    this._canvas.setPixel(p.x+3, p.y-2, p.c);
                    this._canvas.setPixel(p.x-3, p.y-2, p.c);
                    this._canvas.setPixel(p.x+1, p.y-3, p.c);
                    this._canvas.setPixel(p.x-1, p.y-3, p.c);
                }
                else if(this._forceMap.getPixel(p.x, p.y) > 0x888888){ // 文字を伝う雨粒
                    p.x += p.vx -0.02;
                    p.y += p.vy/1.5;
                    p.c = 0xd0ffff; 
                    
                    this._canvas.setPixel(p.x, p.y, p.c);
                    this._canvas.setPixel(p.x, p.y+1, p.c);
                }
                else if(this._forceMap.getPixel(p.x, p.y-7) > 0x888888 ||
                    this._forceMap.getPixel(p.x-3, p.y)){ // 文字から垂れる雨粒
                    p.x += p.vx - 0.05;
                    p.y += p.vy;
                    p.c = 0xb0ffff;
                    
                    this._canvas.setPixel(p.x, p.y, p.c);
                    this._canvas.setPixel(p.x, p.y+1, p.c);
                }
                else{ // 通常の雨粒
                    p.x += p.vx - 0.25;
                    p.y += p.vy*2.5;
                    p.c = 0xb2ffff;
                    
                    this._canvas.setPixel(p.x, p.y, p.c);
                    this._canvas.setPixel(p.x, p.y+1, p.c);
                    this._canvas.setPixel(p.x, p.y+2, p.c);
                    this._canvas.setPixel(p.x-1, p.y+3, p.c);
                    this._canvas.setPixel(p.x-1, p.y+4, p.c);
                    this._canvas.setPixel(p.x-1, p.y+5, p.c);
                }

                
                
                if (p.y > this.stage.stageHeight) { // もし画面外にでちゃったら
                    this._snow.splice(n, 1); // とりのぞく
                }
            }
            this._canvas.unlock(); // lock したやつは必ず unlock
          
            //this._glow.draw(this._canvas, this._glowMtx); // キラキラを描く
          
            
            // 雪を発生させますよ
            n = 10;
            while (n--) {
                this.emitParticle(Math.random() * this.stage.stageWidth+30, 0, Math.random() + 0.5);
            }
        }
    }
}


class SnowParticle {
    
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var s:Number;
    public var c:int;
    
    public function SnowParticle() {
        this.x = 0;
        this.y = 0;
        this.vx = 0;
        this.vy = 0;
        this.s = 1;
        this.c = 0xffffff;
    }
}