/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hY6Z
 */

/*
wonderfl向けに写真の差し替えをしたほうがいいかも。
*/
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.net.*;

    public class Main extends Sprite{
        private var loadFiles_array:Array;
        private var credit_array:Array = new Array();
        private var url_array:Array = new Array();
        private var count_array:Array = new Array();
        private var scale_array:Array = new Array();
        private var newFormat:TextFormat = new TextFormat();
        private var count:uint;
        private var photoby:TextField = MakeUI.newTextField([630,0,300,18,"",0], [["selectable", false],["filters",[new DropShadowFilter(0,0,0xFFFFFF,1,4,4,4)]]]);
        private var myStageWidth:int;
        private var myStageHeight:int;
        private var Dammy:DammyClass = new DammyClass();
        private var photobyURL:String;
        private var fullScreen:TextField = MakeUI.newTextField([,,100,18, "FullScreen",0xFFFFFF], [["selectable", false],["visible",false]]);
        private var fullScreenCount:int;
        private var MultiLoader:MultiLoaderClass;
        private var baseURL:String = "";
        private var dataxmlURL:String = "swf/main/data.xml";
        public function Main(){
            if(isMztmjp()){
                MultiLoader = new MultiLoaderClass();
                baseURL = "http://www.mztm.jp/wp/";
            }else{
                baseURL = "http://mztm.jp/wonderfl/";

                MultiLoader = new MultiLoaderClass("http://mztm.jp/crossdomain.xml");
                dataxmlURL = "swf/main/data2.xml";
            }
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = "TL";
            loadFiles_array = MultiLoader.setLoad([baseURL+dataxmlURL], onXMLComp);
        }
        private function isMztmjp():Boolean{
            var _str:String = stage.loaderInfo.url;
            return (_str.substr(0,5) == "file:" || _str.indexOf("mztm.jp") > -1);
        
        }
        private function onXMLComp(e:Array):void{
            var jpg_array:Array = new Array();
            var data_xml:XML = XML(loadFiles_array[0].data);
            var m:int = int(Math.random() * data_xml.items.length());
            var shuffle_array:Array = Utill.shuffle(data_xml.items[m].item.length() - 1);
            for (var i:int = 0; i < shuffle_array.length; i++) {
                var n:int = shuffle_array[i]+1;
                if(data_xml.items[m].item[n].jpg != ""){
                    jpg_array.push(String(baseURL+data_xml.items[m].item[n].jpg));
                    credit_array.push(String(data_xml.items[m].item[n].credit));
                    url_array.push(String(data_xml.items[m].item[n].url));
                }
            }
            jpg_array.push(baseURL+String(data_xml.items[m].item[0].jpg));
            credit_array.push(String(data_xml.items[m].item[0].credit));
            url_array.push(String(data_xml.items[m].item[0].url));
            loadFiles_array = new Array();
            loadFiles_array = MultiLoader.setLoad(jpg_array,onImgComp);
        }
        private function onImgComp(e:Array):void{
            addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
            var _length:int = loadFiles_array.length;
            for (var i:int = 0; i < _length; i++) {
                Dammy.setBitmap(loadFiles_array[i], i);
                if(loadFiles_array[i].contentLoaderInfo.contentType.substr(0,5) == "image"){
                    var bmp_data:BitmapData = new BitmapData(loadFiles_array[i].width, loadFiles_array[i].height);
                    bmp_data.draw(loadFiles_array[i]);
                    loadFiles_array[i].unload();
                    loadFiles_array[i] = new Bitmap( bmp_data, "auto", true);
                }
                count_array[i] = 0;
                loadFiles_array[i].alpha = 0;
                //loadFiles_array[i].rotation = i * 5;
                addChild(loadFiles_array[i]);
            }
            addChild(photoby);
            photoby.text = credit_array[0];
            photobyURL = url_array[0];
            photoby.setTextFormat(MakeUI.newTextFormat(newFormat, {align:"right" } ));
            photoby.addEventListener(MouseEvent.CLICK, onClickLink);
            resizeHandler();
            stage.addEventListener(Event.RESIZE, resizeHandler);
            fullScreen.setTextFormat(MakeUI.newTextFormat(newFormat, { align:"right" } ));
            fullScreen.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouse_over);
            addChild(fullScreen);
        }
        private function onMouse_over(e:MouseEvent = null):void{
            fullScreen.visible = true;
            fullScreenCount = 0;
        }
        private function onClickLink(e:MouseEvent = null):void{
            navigateToURL(new URLRequest(photobyURL));
        }
        
        private function onClick(e:MouseEvent = null):void{
            if(stage.displayState == "normal"){
                stage.displayState = "fullScreen";
            }else{
                stage.displayState = "normal";
            }
        }
        private function ENTER_FRAME(e:Event = null):void{
            count ++;
            if(fullScreenCount < 100){
                fullScreenCount++;
            }else if(fullScreenCount == 100){
                fullScreenCount++;
                fullScreen.visible = false;
            }
            var _length:int = count_array.length;
            var n:int = int(count/300)%_length;
            var i:int;
            var cnt:Number = (count % 300 + 1) / 300;
            
            for (i = 0; i < _length; i++) {
                Dammy._array[i].visible = false;
            }
            
            if(cnt == 1 && n == _length-1){
                for (i = 0; i < _length; i++) {
                    count_array[i] = 0;
                }
                Dammy.begin();
            }else{
                if(n < _length-1 && cnt > 0.9){
                    count_array[n + 1] += 1 / 330;
                    Dammy._array[n + 1].visible = true;
                }
                count_array[n] += 1 / 330;
                Dammy._array[n].visible = true;
            }
            if(cnt < 2/300){
                photoby.text = credit_array[n];
                photoby.setTextFormat(MakeUI.newTextFormat(newFormat, {align:"right" } ));
                photobyURL = url_array[n];
            }
            for (i = 0; i < _length; i++) {
                slideSaver(i,count_array[i]);
            }
            Dammy.run(loadFiles_array);
            
        }
        private function slideSaver(num:int,per:Number):void{
            if (per > 1) { per = 1 };
            var poz:int = Dammy._array[num].random;
            var _scale:Number;
            if(poz > 50){
                _scale = 0.9 + per / 10;
            }else {
                _scale = 1 - per / 10;
            }
            if (poz%7 == 0) {
                Dammy._array[num].x = (myStageWidth - loadFiles_array[num].width) / 2;
                Dammy._array[num].y = (myStageHeight - loadFiles_array[num].height) / 2;
            }else if (poz%7 == 1) {
                Dammy._array[num].x = myStageWidth - loadFiles_array[num].width+2;
                Dammy._array[num].y = 0;
            }else if (poz%7 == 2) {
                Dammy._array[num].x = myStageWidth - loadFiles_array[num].width+2;
                Dammy._array[num].y = myStageHeight - loadFiles_array[num].height+2;
            }else if (poz%7 == 3) {
                Dammy._array[num].x = 0;
                Dammy._array[num].y = myStageHeight - loadFiles_array[num].height+2;
            }else if (poz%7 == 4) {
                Dammy._array[num].x = 0;
                Dammy._array[num].y = 0;
            }else if (poz%7 == 5) {
                Dammy._array[num].x = 0;
                Dammy._array[num].y = (myStageHeight - loadFiles_array[num].height) / 2;
            }else if (poz%7 == 6) {
                Dammy._array[num].x = myStageWidth - loadFiles_array[num].width + 2;
                Dammy._array[num].y = (myStageHeight - loadFiles_array[num].height) / 2;
            }
            
            Dammy._array[num].scaleX = Dammy._array[num].scaleY = scale_array[num] * _scale;
            var _alpha:Number = Math.min(1,per*10);
            Dammy._array[num].alpha = _alpha;
            if (num > 0 && (0.8 < _alpha && _alpha < 1)) {
                Dammy._array[num - 1].visible = true;
            }
        }
        private function resizeHandler(event:Event = null):void{
            myStageWidth = stage.stageWidth;
            myStageHeight = stage.stageHeight;
            fullScreen.x = myStageWidth - 106;
            photoby.y = myStageHeight - 18;
            photoby.x = myStageWidth - 306;
            var _length:int = loadFiles_array.length;
            for (var i:int = 0; i < _length; i++) {
                scale_array[i] = (Math.max(myStageWidth / Dammy._array[i].originalWidth, myStageHeight / Dammy._array[i].originalHeight)) * 1.15;
            }
        }
    }
}
//originalWidth

class Utill extends Sprite {
    public static function shuffle(_n:int):Array {
        var _array:Array = new Array(); 
        for (var i:int= 0; i<_n; i++){ 
            _array[i] = Math.random(); 
        } 
        return _array.sort(Array.RETURNINDEXEDARRAY); 
    } 
}


import flash.display.DisplayObject;
import flash.display.Loader;
class DammyClass extends Sprite{
    public var _array:Array = new Array();
    private var old_array:Array = new Array();
    public var _obj:Object = new Object();
    //public var bmp_obj:Object = new Object();
    private var item_array:Array = new Array();
    public function setBitmap(arg:*,_id:*):void{
        var typeof_id:String = typeof _id;
        if(typeof_id == "number"){
            _array[_id] = getObject(arg);
            old_array[_id] = getObject(arg);
            item_array[_id] = arg;
            random();
        }else if(typeof_id == "string"){
            _obj[_id] = getObject(arg);
        }
    }
    public function begin():void {
        //Dammy._array[i].scaleX = Dammy._array[i].scaleY = 1;
        for (var i:int = 0; i < _array.length; i++) {
            _array[i].scaleX = _array[i].scaleY = 1;
            _array[i].x = _array[i].y = 0;
            _array[i].alpha = 0;
            _array[i].visible = false;
            //_array[i].width = 936;
            //_array[i].height = 320;
            
        }
        random();
    }
    public function random():void {
        for (var i:int = 0; i < _array.length-1; i++) {
            _array[i]["random"] = int(Math.random() * 100);
        }
        _array[_array.length - 1]["random"] = 0;
    }
    public function run(_ar:Array):void {
        for (var i:int = 0; i < _ar.length; i++) {
            if (_array[i].alpha != old_array[i].alpha) {
                _ar[i].alpha = old_array[i].alpha = _array[i].alpha;
            }
            if (_array[i].scaleX != old_array[i].scaleX) {
                _ar[i].scaleX = old_array[i].scaleX = _array[i].scaleX;
            }
            if (_array[i].scaleY != old_array[i].scaleY) {
                _ar[i].scaleY = old_array[i].scaleY = _array[i].scaleY;
            }
            //if (_array[i].width != old_array[i].width) {
                //_ar[i].width = old_array[i].width = _array[i].width;
            //}
            //if (_array[i].height != old_array[i].height) {
                //_ar[i].height = old_array[i].height = _array[i].height;
            //}
            if (_array[i].visible != old_array[i].visible) {
                _ar[i].visible = old_array[i].visible = _array[i].visible;
            }
            if (_array[i].x != old_array[i].x) {
                _ar[i].x = old_array[i].x = _array[i].x;
            }
            if (_array[i].y != old_array[i].y) {
                _ar[i].y = old_array[i].y = _array[i].y;
            }
        }
    }
    
    
    private function getObject(arg:*):Object{
        var __obj:Object = new Object();
        __obj["alpha"] = arg.alpha;
        __obj["originalWidth"] = arg.width;
        __obj["originalHeight"] = arg.height;
        //__obj["scaleX"] = arg.scaleX;
        //__obj["scaleY"] = arg.scaleY;
        __obj["visible"] = arg.visible;
        __obj["x"] = arg.x;
        __obj["y"] = arg.y;
        return __obj;
    }
    //var contentType:String = arg.contentLoaderInfo.contentType;
    //contentType == "image/jpeg"
}

import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
class MakeUI{
    public static var defaultTextFormat:TextFormat = new TextFormat();
    public static function newShape(x_y_w_h_sh:Array = null,property:Array=null,graphics:Array=null):Shape{
        var i:int;
        var sh:Shape;
        if(x_y_w_h_sh && x_y_w_h_sh[4]){
            sh = x_y_w_h_sh[4];
        }else{
            sh = new Shape();
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[0]) { sh.x = x_y_w_h_sh[0] };
            if (x_y_w_h_sh[1]) { sh.y = x_y_w_h_sh[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sh[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sh.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[2]) { sh.width = x_y_w_h_sh[2] };
            if (x_y_w_h_sh[3]) { sh.height = x_y_w_h_sh[3] };
        }
        return sh;
    }
    public static function newSprite(x_y_w_h_sp:Array = null,property:Array=null,graphics:Array=null,addChild:DisplayObject = null):Sprite{
        var i:int;
        var sp:Sprite;
        if(x_y_w_h_sp && x_y_w_h_sp[4]){
            sp = x_y_w_h_sp[4];
        }else{
            sp = new Sprite();
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[0]) { sp.x = x_y_w_h_sp[0] };
            if (x_y_w_h_sp[1]) { sp.y = x_y_w_h_sp[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sp[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sp.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(addChild){
            sp.addChild(addChild);
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[2]) { sp.width = x_y_w_h_sp[2] };
            if (x_y_w_h_sp[3]) { sp.height = x_y_w_h_sp[3] };
        }
        return sp;
    }

    public static function newTextField(x_y_w_h_txt_color_alpha:Array = null,property:Array=null,method:Array=null):TextField{
        var i:int;
        var ta:TextField = new TextField();
        ta.defaultTextFormat = defaultTextFormat;
        if(x_y_w_h_txt_color_alpha){
            if (x_y_w_h_txt_color_alpha[0]) { ta.x = x_y_w_h_txt_color_alpha[0] };
            if (x_y_w_h_txt_color_alpha[1]) { ta.y = x_y_w_h_txt_color_alpha[1] };
            if (x_y_w_h_txt_color_alpha[2]) { ta.width = x_y_w_h_txt_color_alpha[2] };
            if (x_y_w_h_txt_color_alpha[3]) { ta.height = x_y_w_h_txt_color_alpha[3] };
            if (x_y_w_h_txt_color_alpha[4]) { ta.text = x_y_w_h_txt_color_alpha[4] };
            if (x_y_w_h_txt_color_alpha[5]) { ta.textColor = x_y_w_h_txt_color_alpha[5] };
            if (x_y_w_h_txt_color_alpha[6]) { ta.alpha = x_y_w_h_txt_color_alpha[6] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    ta[property[i][0]] = property[i][1];
                }
            }
        }
        if(method){
            for (i = 0; i < method.length; i++) {
                if(method[i] && method[i].length > 1){
                    ta[i].apply(null, method[i][1]);
                }
            }
        }
        return ta;
    }
    
    public static function newTextFormat(_tf:TextFormat = null,property:Object = null):TextFormat{
        var tf:TextFormat;
        if(_tf){
            tf = _tf;
        }else{
            tf = new TextFormat();
        }
        if(property){
            for (var str:String in property) {
                tf[str] = property[str];
            }
        }
        return tf;
    }
    //以下はテスト
    public static function pozObject(x:Number=NaN,y:Number=NaN,width:Number=NaN,hight:Number=NaN,obj:Object = null):Object{
        if(x){obj.x = x}
        if(y){obj.y = y}
        return obj;
    }
    public static function newBitmap(x:Number=NaN,y:Number=NaN,width:Number=NaN,hight:Number=NaN,bd:BitmapData = null):Bitmap{
        var b:Bitmap = new Bitmap(bd);
        if(x){b.x = x}
        if(y){b.y = y}
        return b;
    }
}


import flash.display.Sprite;
class MultiLoaderClass extends Sprite{
    import flash.system.Security;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.display.Loader;
    //import flash.display.LoaderInfo;
    
    private var onComplete:Function = function(arg:Array=null):void{};
    //private var onOpen:Function = function():void{};
    private var loadNum:int;
    private var loadCompNum:int;
    private var error_array:Array = new Array();
    private var URLs_array:Array = new Array();
    private var _uniqueParam:String = "";
    
    public function set uniqueParam(uStr:String):void {
        if (uStr) {
            if (uStr.substr(0,2) == "?=") {
                _uniqueParam = uStr;
            }else {
                _uniqueParam = "?=" + uStr;
            }
        }else {
            _uniqueParam = "";
        }
    }
    public function get uniqueParam():String {
        return _uniqueParam;
    }
    
    public function MultiLoaderClass(_str:String = null,uStr:String = null){
        if(_str){
            Security.loadPolicyFile(_str);
        }
        uniqueParam = uStr;
    }
    
    public function setLoad(__item_array:Array = null, _onComp:Function = null):Array {
        loadCompNum = loadNum = 0;
        if(_onComp != null){
            onComplete = _onComp;
        }
        if (__item_array.length == 0) {
            loadNum ++;
            onComplete();
        }
        
        URLs_array = __item_array.concat();
        error_array = new Array();
        //onOpen = _onOpen;
        var _array:Array = new Array();
        var _length:int = __item_array.length;
        for (var i:int = 0; i < _length; i++) {
            error_array[i] = false;
            if (__item_array[i] == null) { continue };
            var _extension:String = __item_array[i].substr(-4,4).toLowerCase();//拡張子を取り出す。
            if (_extension == ".xml" || _extension == "html") {
                loadNum ++;
                _array[i] = textFromURL(__item_array[i] + uniqueParam);
            }else if(_extension == ".jpg" || _extension == ".gif" || _extension == ".png" || _extension == ".swf"){
                loadNum ++;
                _array[i] = imgFromURL(__item_array[i] + uniqueParam);
            }else if(_extension == ".bin"){
                loadNum ++;
                __item_array[i] = __item_array[i].substr(0, __item_array[i].length - 4);
                _array[i] = binaryFromURL(__item_array[i] + uniqueParam);
            }else{
                //_array[i] = null;
            }
        }
        
        return _array;
    }
    private function binaryFromURL(__url:String):URLLoader{
        var _loader:URLLoader = new URLLoader();
        _loader.dataFormat = URLLoaderDataFormat.BINARY;
        _loader.addEventListener(Event.COMPLETE,completeHandler);
        _loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function textFromURL(__url:String):URLLoader{
        var _loader:URLLoader = new URLLoader();
        _loader.addEventListener(Event.COMPLETE,completeHandler);
        _loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        //_loader.addEventListener(Event.OPEN,openHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function imgFromURL(__url:String):Loader{
        var _loader:Loader = new Loader();
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        //_loader.contentLoaderInfo.addEventListener(Event.OPEN,openHandler);
        _loader.load(new URLRequest(__url));
        return _loader;
    }
    
    private function completeHandler(event:Event = null):void {
        loadCompNum ++;
        if(loadCompNum == loadNum){
            onComplete(error_array);
        }
    }
    /*
    private function openHandler (event:Event):void {
        if(Math.random()>0.95){
            trace ("読み込みを開始した");
            //event.currentTarget.contentLoaderInfo.close();
            var str:String = event.currentTarget.toString().substr(8);
            if(str == "LoaderInfo]"){
                //event.currentTarget.contentLoaderInfo.close();
                //event.target.contentLoaderInfo.close();
                //event.currentTarget.close();
                //event.target.close();
            }else if(str == "URLLoader]"){
                event.currentTarget.close();
                completeHandler();
            }
            
            //completeHandler();
            //onOpen();
        }
    }
    */
    private function ioErrorHandler(event:IOErrorEvent):void {
        //event.text = "Error #2035: URL が見つかりません。 URL: file:///~~~~~";
        //event.text = "Error #2036: 読み込みが未完了です。 URL: http://~~~~~";
        //から、URLのみを取り出す。
        //trace(String(event.text).substr(String(event.text).indexOf(" URL: ")+6),"*****");
        for (var i:int = 0; i < URLs_array.length; i++) {
            var _str:String = String(event.text).substr(String(event.text).indexOf(" URL: ")+6).substr(-URLs_array[i].length);
            if(URLs_array[i] == _str){
                error_array[i] = true;
            }
        }
        completeHandler();
    }
}