/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hY5n
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	
	[SWF(width=465,height=465,backgroundColor=0xFFFFFF)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const CNT:int = 10;
		private var canvas:BitmapData;
		private var circle:Sprite;
		private var particles:Vector.<Particle> = new Vector.<Particle>(CNT,true);
		private var n:Number = 0;
		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.BEST;
			Wonderfl.capture_delay( 15 );
			
			canvas = new BitmapData(465, 465, false, 0x0);
			var bmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;
			bmp.filters = [new BlurFilter(1.2, 1.2, 1)];
			
			circle = new Sprite();
			circle.graphics.lineStyle(0, 0);
			circle.graphics.beginFill(0xAAAAAA);
			circle.graphics.drawCircle(0, 0, 15);
			
			for (var i:int = 0; i < particles.length; i++)
			{
				var p:Particle = new Particle();
				p.x = Math.random() * 465;
				p.y = Math.random() * 465;
				particles[i] = p;
			}
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			for (var i:int = 0; i < particles.length; i++)
			{
				var p:Particle = particles[i] as Particle;
				p.vx += Math.random() * 2 - 1;
				p.vy += Math.random() * 2 - 1;
				p.x += p.vx;
				p.y += p.vy;
				p.vx *= 0.95;
				p.vy *= 0.95;
				
				if (p.x > 480) p.x = -15;
				else if (p.x < -15) p.x = 480;
				if (p.y > 480) p.y = -15;
				else if (p.y < -15) p.y = 480;
				
				n += .005;
				var s:Number =  Math.sin(n) * 30 + 20;
				p.c.blueOffset = s;
				var m:Matrix = new Matrix();
				m.translate(p.x, p.y);
				canvas.draw(circle, m,p.c);
			}
		}
	}
}

import flash.geom.ColorTransform;

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var c:ColorTransform;
	
	public function Particle()
	{
		c = new ColorTransform(1, 1, 1, 1, Math.random() * 25 + 25, Math.random() * 25 + 25, 0, 0);
	}
}