/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hX6U
 */

package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    
    public class Main extends Sprite 
    {
        
        private const BG_COLOR:uint = 0xCCCCCC;
        private const STAGE_WIDTH:int = 400;
        private const STAGE_HEIGHT:int = 400;
        
        private var _color0:uint = 0x33FFCC;
        private var _color1:uint = 0x000000;
        
        // constructor
        public function Main():void {
            init();
        }
        
        // 
        private function init():void {
            // bg
            var bgSp:Sprite = new Sprite();
            bgSp.graphics.lineStyle();
            bgSp.graphics.beginFill(BG_COLOR, 1.0);
            bgSp.graphics.drawRect(0, 0, STAGE_WIDTH, STAGE_HEIGHT);
            bgSp.graphics.endFill();
            this.addChild(bgSp);
            // グリッド描画
            drawGrid(bgSp, 50, 50);
            
            var sp:Sprite = new Sprite();
            this.addChild(sp);
            
            // 円描画
            drawMyCircle(sp, 100, 100, 10, 30, 10, 4);
        }
        
        // グリッド描画
        private function drawGrid(sp:Sprite, dx:int = 50, dy:int = 50):void {
            var g:Graphics = sp.graphics;
            var i_max:int;
            var i:int;
            
            g.lineStyle(1, 0x000000, 1.0);
            
            i_max = int(STAGE_WIDTH / dx);
            for (i = 1; i < i_max; i++) {
                g.moveTo(i * dx, 0);
                g.lineTo(i * dx, STAGE_HEIGHT);
            }
            
            i_max = int(STAGE_HEIGHT / dy);
            for (i = 1; i < i_max; i++) {
                g.moveTo(0, i * dy);
                g.lineTo(STAGE_WIDTH, i * dy);
            }
        }
        
        // 円描画（引数多すぎ・・・＞＜；）
        private function drawMyCircle(sp:Sprite, x:int = 100, y:int = 100, r:int = 10, deg:int = 0, len:int = 4, num:int = 10):void {
            var i:int;
            var rad:Number = deg / 180 * Math.PI;
            var dx:Number = len * Math.cos(rad);
            var dy:Number = len * Math.sin(rad);
            var dr:Number = len * 2;
            var color:uint;
            
            var g:Graphics = sp.graphics;
            g.clear();
            
            for (i = 0; i < num; i++) {
                color = i % 2 ? _color0 : _color1;
                g.lineStyle(2, color, 1.0);
                g.drawCircle(x + dx * i, y + dy * i, r + dr * i);
            }
        }
    }
}