/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hX0C
 */

package 
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends Sprite
    {
        private var NUM:int = 10;
        private var _minDist:Number = 120;
        private var _springAmount:Number  = 0.001 // バネ係数
        private var _ballArr:Array = [];
        private var ID:int = 0;
        
        private var _layer:Sprite;
        private var _ball:Sprite;
        private var _g:Graphics;
        private var BG:Bitmap;
        private var _defBmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF000000);
        private var _defBm:Bitmap = new Bitmap( _defBmd );
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
            
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                removeEventListener(Event.ENTER_FRAME, enterframeHandler);
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
            
            BG = addChild( new Bitmap() ) as Bitmap;
            BG.bitmapData = _defBmd;
            
            _ball  = addChild( new Sprite() )as Sprite;
            _layer = addChild( new Sprite() )as Sprite;
            _g = _layer.graphics;
            
            _ball.visible = _layer.visible = false;
            
            ballCreate();
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
            stage.addEventListener(MouseEvent.CLICK, function():void{
                if(_ball.visible == false){
                    _ball.visible = true;
                    _layer.visible = true;
                    BG.visible = false;
                }else{
                    _ball.visible = false;
                    _layer.visible = false;
                    BG.visible = true;
                }
            });
        }
        
        private function ballCreate():void
        {
            var b:Ball = new Ball();
            _ball.addChild(b);
            b.x = stage.stageWidth*Math.random();
            b.y = stage.stageHeight*Math.random();
            b._vx = 2*Math.random() - 1;
            b._vy = 2*Math.random() - 1;
            b._mass = 10 * Math.random() + 2;
            _ballArr[ID] = b;
            
            if (NUM >= ID ) {
                ID++;
                Tweener.addTween(b, { alpha:1, time:.5, onComplete:function():void{ ballCreate(); } } )
            }
        }
        
        private function enterframeHandler(e:Event):void
        {
            _g.clear();
            
            for(var i:int=0; i<_ballArr.length; i++ ){
                var b:Ball = _ballArr[i];
                b.x += b._vx;
                b.y += b._vy;
                checkWalls(b);
            }
            
            for(i=0; i<_ballArr.length-1; i++ ){
                var b0:Ball = _ballArr[i];
                for(var n:int=i+1; n<_ballArr.length; n++){
                    var b1:Ball = _ballArr[n];
                    spring(b0, b1);
                }
            }
            
            BG.bitmapData.draw( _layer, null, new ColorTransform(1,1,1,0.1), null, null, true );
            
            var filArr:Array = new Array();
            var f:BlurFilter = new BlurFilter(5,5);
            filArr.push(f);
            BG.filters = filArr;
        }
        private function spring(b0:Ball, b1:Ball):void
        {
            var dx:Number = b1.x - b0.x;
            var dy:Number = b1.y - b0.y;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            if (dist < _minDist)
            {
                var cx:Number = dx/2+b0.x;
                var cy:Number = dy/2+b0.y;
                _g.lineStyle(1, 0xFFFFFF,  1- dist/_minDist);
                _g.moveTo(b0.x, b0.y);
                _g.lineTo(b1.x, b1.y);
                
                var ax:Number = dx * _springAmount;
                var ay:Number = dy * _springAmount;
                b0._vx += ax / b0._mass;
                b0._vy += ay / b0._mass;
                b1._vx -= ax / b1._mass;
                b1._vy -= ay / b1._mass;
            }
        }
        
        private function checkWalls(b:Ball):void
        {
            if(b.x-b.width/2 > stage.stageWidth){
                b.x = -b.width/2;                    
            }else if( b.x+b.width/2 < 0 ){
                b.x = stage.stageWidth+b.width/2;
            }            
            if( b.y-b.height/2 > stage.stageHeight ){
                b.y = -b.height/2;
            }else if( b.y+b.height/2 < 0){
                b.y = stage.stageHeight+b.height/2;
            }
        }
        
        /********* stage set ************/
        
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {
            
        }
        
    }
}

import flash.display.Sprite;
class Ball extends Sprite
{
    public var _radius:Number;
    public var _vx:Number = 0;
    public var _vy:Number = 0;
    public var _mass:Number = 1;
    
    public function Ball(radius:Number = 2)
    {
        _radius = radius;
        init();
    }
    
    public function init():void
    {
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0,0,_radius);
        graphics.endFill();
    }
}
