/**
 * Copyright thoton ( http://wonderfl.net/user/thoton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hWz4
 */

// forked from thoton's forked from: 3D tag cloud
// forked from esabear's 3D tag cloud
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.text.TextField;
        import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.special.BitmapParticleMaterial;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.events.InteractiveScene3DEvent;

    public class FlashTest extends Sprite {
        private var scale:Number = 2;
        private var radius:Number = 500;
        private var smoothing:Boolean = true;
        private var minAlpha:Number = 0.1;
        private var glow:GlowFilter;
        private var tags:Array;
        private var tag_num:uint;
        private var bv:BasicView;
        private var tagArray:Array;
        private var tagContainer:DisplayObject3D;

        public function FlashTest() {
            // write as3 code here..
            init ();
        }
        
        private function init ():void {
            glow = new GlowFilter (0x003366, 1, 8, 8, 2, BitmapFilterQuality.LOW, true, false);
            // tags = ["三\n寒\n四\n温","ひ\nの\nな\nい\nと\nこ\nろ\nに\nけ\nむ\nり\nは\nた\nた\nな\nい","C","D","E","F","G","H","I","J","K","L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",];
            // tags = ["A","B","C","D","E","F","G","H","I","J","K","L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",];
            // tags = ["あ\nい\nう\nえ\nお","かきくけこ","さ\nし\nす\nせ\nそ","たちつてと","は\nひ\nふ\nへ\nほ","まみむめも","や\nゆ\nよ","らりるれろ","わ\nを\nん"];

//            tags = [
// "←", "accent","accented","accentless","accent mark","accentor","accentual","accentuate","accentuation","accept","acceptability","acceptable","acceptably","acceptance",
// "acceptant","acceptation","accepted","accepter","acceptor","access","accessary","accessibility",
// "accessible","accession","accessorial","accessorize","accessory","access provider","access time","acciaccatura",
// "accidence","accident","accidental","accidentally","accident and emergency",
// "accident insurance","accident-prone","accidie", "→"
// ];

            tags = ["索\n吨\n全\n球\n计\n算", "اللغة العربية", "ราตรีสวัสดิ์", "thoton\nglobal computing\ne-dictionaries\n2010","japanese\nmonolingual", "english-japanese\ndictionary", "dictionnaire\nfrançais-japonais"];
 
 //           tags = [
// "■\n亜\n鉛\n　\nあ\n‐\nえ\nん",
// "■\n亜\n鉛\n華\n　\nあ\nえ\nん\n‐\nか",
// "■\n亜\n鉛\n華\n軟\n膏\n　\nあ\nえ\nん\nか\n‐\nな\nん\nこ\nう",
// "■\n亜\n鉛\n鉄\n板\n　\nあ\nえ\nん\n‐\nて\nっ\nぱ\nん",
// "■\n亜\n鉛\n凸\n版\n　\nあ\nえ\nん\n‐\nと\nっ\nぱ\nん",
// "■\n亜\n鉛\n版\n　\nあ\nえ\nん\n‐\nば\nん",
// "■\n亜\n欧\n　\nあ\n‐\nお\nう",
// "■\n亜\n欧\n堂\n田\n善\n　\nあ\nお\nう\nど\nう\n‐\nで\nん\nぜ\nん",
// "■\n亜\n科　\nあ\n‐\nか"
//            ];
            
            tag_num = tags.length;
            tagArray = [];
            tagContainer = new DisplayObject3D ("tag_container");
            tagContainer.x = -radius * 0.25;
            tagContainer.y =  radius * 0.25;
            
            bv = new BasicView (stage.stageWidth, stage.stageHeight, true, true);
            bv.viewport.interactive = true;
            bv.scene.addChild (tagContainer);
            bv.camera.z = -1.5 * radius;
            bv.camera.zoom = 20;
            bv.startRendering ();
            
            addChild (bv);
            
            buildTags ();
            
            addEventListener (Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function buildTags ():void {
            var i:uint;
            for (i = 0; i < tag_num; i++) {
                // 2D
                var txt:TextField = new TextField ();

var Fmt:TextFormat;
Fmt = new TextFormat();
Fmt.font = "ヒラギノ明朝 Pro W6";

// embedFmt.font = "_ゴシック";
Fmt.size = 12;
Fmt.color = 0x000000;
txt.setTextFormat(Fmt);

                txt.antiAliasType = "advanced";
                txt.text = tags[i];
                            
                txt.filters = [new BlurFilter(1.1, 1.1)];
                // textformat.font = ;

                                                
                var txtW:Number = txt.textWidth + 4;
                var txtH:Number = txt.textHeight + 4;
                var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
                    bitmap.draw (txt);

                var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
                var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

                // 3D
                var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
                    material.interactive = true;
                    material.smooth = smoothing;
                var tag:Particle = new Particle (material, scale, 0, 0, 0);
                var tagHolder:Particles = new Particles ("tag_");
                    tagHolder.addParticle (tag);
                    tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
                    tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
                    tagHolder.z = radius * Math.cos (phi);
                    tagHolder.useOwnContainer = true;
                    tagHolder.autoCalcScreenCoords = true;
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                    //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

                tagContainer.addChild (tagHolder);
                tagArray.push (tagHolder);
            }
        }
        
        private function objectOverHandler (e:InteractiveScene3DEvent):void {
        bv.viewport.buttonMode = true;
            e.target.filters = [glow];
        }

        private function objectOutHandler (e:InteractiveScene3DEvent):void {
        bv.viewport.buttonMode = false;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray [j].filters = [];
            }
        }
        
        private function enterFrameHandler (e:Event):void {
            tagContainer.rotationX += (mouseY - stage.stageHeight * 0.5) * 0.01;
            tagContainer.rotationY += (mouseX - stage.stageWidth * 0.5) * 0.01;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray[j].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[j].screen.z - radius) / (2 * radius));
            }
        }
    }
}