/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hWk9
 */

// forked from tkinjo's Sine Wave
package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		private const FREQUENCY:Number = 1;
		private const WAVELENGTH:Number = 200;
		private const AMPLITUDE:Number = 100;
		private const SPEED:uint = 5;
		
		private var screen:Bitmap;
		private var outputtingSignal:Vector.<Number>;
		private var nonOutputSignal:Vector.<Number>;
		
		public function Main() 
		{
			screen = new Bitmap();
			addChild( screen );
			
			outputtingSignal = new Vector.<Number>;
			nonOutputSignal = new Vector.<Number>;
			
			for ( var i:uint = 0; i < stage.stageWidth; i++ ) {
				
				outputtingSignal.push( 0 );
			}
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
			
			stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
		}
		
		private function enterFrameHandler( event:Event ):void {
			
			var canvas:Sprite = new Sprite();
			var canvasGraphics:Graphics = canvas.graphics;
			
			canvasGraphics.lineStyle( 1 );
			
			canvasGraphics.moveTo( 0, outputtingSignal[ 0 ] );
			for ( var i:uint = 1; i < stage.stageWidth; i++ ) {
				
				canvasGraphics.lineTo( i , outputtingSignal[ i ] );
			}
			
			// シフト処理
			for ( var j:uint = 0; j < SPEED; j++ ) {
				
				outputtingSignal.pop();
				
				if ( nonOutputSignal.length ) {
					
					outputtingSignal.unshift( nonOutputSignal[ 0 ] );
					nonOutputSignal.shift();
					
				} else {
					
					outputtingSignal.unshift( 0 );
				}
			}
			
			
			var buffer:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight );
			buffer.draw( canvas, new Matrix( 1, 0, 0, 1, 0, stage.stageHeight / 2 ) );
			screen.bitmapData = buffer;
		}
		
		/**
		 * 波形生成
		 * 
		 * @param	event
		 */
		private function mouseDownHandler( event:MouseEvent ):void {
			
			for ( var i:uint = 0; i < WAVELENGTH; i++ ) {
				
				var degrees:Number = i * ( 360 / WAVELENGTH );
				var rad:Number = degrees * ( Math.PI / 180 ) * FREQUENCY;
				var signal:Number = ( Math.sin( rad ) * AMPLITUDE );
				
				if ( i < nonOutputSignal.length )
					nonOutputSignal[ i ] += signal;
					
				else
					nonOutputSignal.push( signal );
			}
		}
	}
	
}

