/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hWSbt
 */

package
{
	import frocessing.FC;
	import frocessing.color.ColorHSV;
	import frocessing.display.F5MovieClip2D;

	import flash.display.StageAlign;
	import flash.display.StageScaleMode;

	[SWF(width=465,height=465,backgroundColor="0x0", frameRate="60")]
    public class LifeCycle extends F5MovieClip2D {
        public function LifeCycle() 
        {
        	stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
        	percent = -Math.random()*Math.PI *2 - Math.PI; // Magic number i made up
        }
        public function setup():void 
        {
            strokeCap( FC.CAPS_STYLE_NONE );
            noStroke();
        }
        
        private var percent	:Number;
		private var HSV:ColorHSV = new ColorHSV(Math.random() * 360, 0.9, 1.0);
        private var arcs:Array = [];
        public function draw():void
        {
        	percent -= 0.003;
        	
			translate( stage.stageWidth/2, stage.stageHeight / 2 );

			
			var fatness			:Number = 1 + stage.mouseX/stage.stageWidth * 100 
			var  center			:Number = Math.max(50, fatness+5)
			var buffer			:Number = 2;
			var arcCount		:int = 3 + ((stage.mouseY / (stage.stageHeight/2)) * 15);
			for(var i:int = 0; i < arcCount;  i++)
			{
				if(arcs[i] == undefined ) arcs[i] = 0.0;
			
				var divisor:Number = (i+1) / arcCount;
				
				// Figure out where we want to end up, slide their slowly
				var endArc:Number = (Math.PI * 2) * percent * divisor;
				endArc = endArc % (Math.PI * 2);
				var myArc:Number = arcs[i]- (arcs[i] - endArc) * 0.25;
				
					
				HSV.h = divisor * 120 + 180;
				// Draw an 2 arcs fill in the middle
				beginFill( HSV.value );
					moveTo( center - fatness + 5, 0 );
					arcTo( 0, 0, center, center, 0, myArc, 0 );
					arcTo( 0, 0, center - fatness, center - fatness, myArc , 0 );
				endFill();
				
				
				// move out 
				center += fatness + buffer;
				arcs[i] = myArc; // Save this to ease next time
			}
        }
    }
}

