/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hW0l
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package 
{
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.media.Camera;
    import flash.media.Video;

    public class Dot01 extends Sprite 
    {

        private var _camera:Camera;
        private var _video:Video;
        public function Dot01()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _camera = Camera.getCamera();

            if (_camera == null)
            {
                trace("not camera");
                return;
            }

            _video = new Video(40,30);
            _video.attachCamera(_camera);

            addEventListener(Event.ENTER_FRAME, loop);
            Wonderfl.capture_delay(10);

            
        }

        private function loop(e:Event):void
        {
            var g:Graphics = graphics;
            var p:BitmapData = camPatern();
            g.beginBitmapFill(p);
            g.drawRect(0,0,500,500);
            g.endFill();

        }

        private var _c:Number = 0;
        private function camPatern():BitmapData
        {
            var pt:Array = [];
            var c:Array = [0x11FFFFFF, 0x11888888];
            var tmpBmpd:BitmapData = new BitmapData(_video.width, _video.height);
            tmpBmpd.draw(_video);
            for (var yi:int=0; yi<tmpBmpd.height; yi++)
            {
                pt[yi] = [];
                for (var xi:int=0; xi<tmpBmpd.width; xi++)
                {
                    pt[yi].push((tmpBmpd.getPixel(xi,yi) < 0x888888)? 0:1)
                }
                
            }
             
            return BitmapPatternBuilder.build(pt,c);
        }
    }
}
/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
 */
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;

class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }

    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}
