/**
 * Copyright corleonis ( http://wonderfl.net/user/corleonis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hVnF
 */

//波線をひくよ。もっと効率の良いやり方あったら教えてください。
package{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	
	[SWF(width = "465", height = "465", backgroundColor = "#FFFFFF")] 
	
	public class Waveline extends Sprite{
		
		private const W_SIZE:uint = 465;
		private const H_SIZE:uint = 465;
		private const freq:uint = 16; //周波数
		private const amp:uint = 3; //振幅
		
		private var bmp:Bitmap;
		private var pen:Sprite;
		private var drawing:Boolean; //描画中フラグ
		private var mdPoint:Point; //マウスダウン時の座標
		private var rc:Number;
		
		
		public function Waveline():void{
			bmp = this.addChild(new Bitmap(new BitmapData(W_SIZE,H_SIZE,true,0x000000))) as Bitmap;
			pen = Sprite(this.addChild(new Sprite()));
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN,mdwnHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP,mupHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,mmovHandler);
		}
		
		//マウスダウン
		private function mdwnHandler(e:MouseEvent):void {
			drawing = true;
			mdPoint = new Point(mouseX, mouseY);
			rc = Math.random() * 0xFFFFFF;
		}
		
		//マウスアップ
		function mupHandler(e:MouseEvent):void {
			drawing = false;
			bmp.bitmapData.draw (pen, pen.transform.matrix);
			pen.graphics.clear();
		}
		
		//マウスムーブ
		function mmovHandler(e:MouseEvent):void {
			if(drawing){
				pen.graphics.clear();
				pen.x = mdPoint.x;
				pen.y = mdPoint.y;
				pen.graphics.lineStyle(2, rc);
				var x:Number, y:Number, rad:Number;
				
				if(Math.abs(mdPoint.x - mouseX) > Math.abs(mdPoint.y - mouseY)){
					if(mdPoint.x < mouseX){
						for (x = 0; x <= mouseX - mdPoint.x; x++) {
							rad = x * freq * Math.PI / 180;
							y = Math.sin(rad) * amp;
							pen.graphics.lineTo(x, y);
						}
					}else{
						for (x = 0; x <= mdPoint.x - mouseX; x++) {
							rad = x * freq * Math.PI / 180;
							y = Math.sin(rad) * amp;
							pen.graphics.lineTo(-x, y);
						}
					}
				}else{
					if(mdPoint.y < mouseY){
						for (y = 0; y <= mouseY - mdPoint.y; y++) {
							rad = y * freq * Math.PI / 180;
							x = Math.sin(rad) * amp;
							pen.graphics.lineTo(x, y);
						}
					}else{
						for (y = 0; y <= mdPoint.y - mouseY; y++) {
							rad = y * freq * Math.PI / 180;
							x = Math.sin(rad) * amp;
							pen.graphics.lineTo(x, -y);
						}
					}
				}
			}
		}
	}
}