/**
 * Copyright yamadori ( http://wonderfl.net/user/yamadori )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hVdl
 */

package {

	import flash.display.*;
	import flash.events.*;
	import flash.filters.BlurFilter;
	
	public class Test extends MovieClip {

		private var circles:Array;

		public function Test() {
			
			circles = [];
			
			for (var i:int = 0; i<30; i++) {
				var c:Sprite = makeCircle();
				c.x = stage.stageWidth / 2;
				c.y = stage.stageHeight / 2;
				c.scaleX = 1 + i/2;
				c.scaleY = 0.5 + i/4;
				c.filters = [new BlurFilter()];
				addChild(c);
				circles.push(c);
			}
			
			addEventListener(Event.ENTER_FRAME, onLoop);
		}

		private function onLoop(evt:Event):void {
			
			circles[0].y += (mouseY - circles[0].y) / 4;
			circles[0].x += (mouseX - circles[0].x) / 4;
			circles[0].rotation = Math.atan2( mouseY - circles[0].y, mouseX - circles[0].x ) * 180/Math.PI ;
			
			for (var i:int = 1; i<circles.length; i++) {
				var pre:Sprite = circles[i - 1];
				circles[i].y += (pre.y - circles[i].y) / 4;
				circles[i].x += (pre.x - circles[i].x) / 4;
				circles[i].rotation = Math.atan2( pre.y - circles[i].y, pre.x - circles[i].x ) * 180/Math.PI ;
			}
		}
		
		private function makeCircle():Sprite {
			var s:Sprite = new Sprite();
			with (s.graphics) {
				lineStyle(0,0x000000);
				drawCircle(0,0,10);
			}
			return s;
		}
	}
}