/**
 * Copyright phi16 ( http://wonderfl.net/user/phi16 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hUxB
 */

package {
    import flash.ui.Mouse;
    import flash.display.Sprite;
    import flash.events.*;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Dynamics.*;
    import Box2D.Dynamics.Joints.*;
    public class FlashTest extends Sprite {
        public var world:b2World;
        public var shape:b2Shape;
        public var mj:b2MouseJoint;
        public var spr:Sprite=new Sprite();
        public function FlashTest(){
            this.x=465/2;
            this.y=465/2;
            var worldAABB:b2AABB=new b2AABB();
            worldAABB.lowerBound.Set(-300,-300);
            worldAABB.upperBound.Set(300,300);
            world=new b2World(worldAABB,new b2Vec2(0,1),false);
            var shapeD:b2PolygonDef=new b2PolygonDef();
            shapeD.vertexCount=4;
            shapeD.vertices[0].Set(-0.2,-0.2);
            shapeD.vertices[1].Set(0.2,-0.2);
            shapeD.vertices[2].Set(0.2,0.2);
            shapeD.vertices[3].Set(-0.2,0.2);
            shapeD.density=1;
            shapeD.restitution=0;
            var bodyD:b2BodyDef=new b2BodyDef();
            bodyD.position.Set(0,0);
            var box:b2Body=world.CreateBody(bodyD);
            shape=box.CreateShape(shapeD);
            box.SetMassFromShapes();
            var walldef0:b2PolygonDef=new b2PolygonDef();
            walldef0.SetAsBox(4.65,0.1);
            var walldef1:b2PolygonDef=new b2PolygonDef();
            walldef1.SetAsBox(0.1,4.65);
            var wall:b2BodyDef=new b2BodyDef();
            wall.position.Set(-4.65/2,-4.65/2);
            world.CreateBody(wall).CreateShape(walldef0);
            wall=new b2BodyDef();
            wall.position.Set(-4.65/2,4.65/2);
            world.CreateBody(wall).CreateShape(walldef0);
            wall=new b2BodyDef();
            wall.position.Set(-4.65/2,-4.65/2);
            world.CreateBody(wall).CreateShape(walldef1);
            wall=new b2BodyDef();
            wall.position.Set(4.65/2,-4.65/2);
            world.CreateBody(wall).CreateShape(walldef1);
            addChild(spr);
            addEventListener(MouseEvent.MOUSE_DOWN,MouseDown);
            addEventListener(MouseEvent.MOUSE_UP,MouseUp);
            addEventListener(MouseEvent.MOUSE_MOVE,MouseMove);
            addEventListener(Event.ENTER_FRAME,Loop);
        }
        public function Loop(e:Event):void{
            world.Step(0.1,10);
            spr.graphics.clear();
            spr.graphics.beginFill(0x000000);
            spr.graphics.drawRect(-465/2,-465/2,465,465);
            spr.graphics.endFill();
            var po:b2Vec2=shape.GetBody().GetPosition();
            var ar:Number=shape.GetBody().GetAngle();
            spr.graphics.lineStyle(1,0xffffff);
            for(var i:int=0;i<4;i++){
                spr.graphics.moveTo(po.x*100+Math.cos((i*90+45)*Math.PI/180+ar)*20*Math.sqrt(2),po.y*100+Math.sin((i*90+45)*Math.PI/180+ar)*20*Math.sqrt(2));
                spr.graphics.lineTo(po.x*100+Math.cos(((i+1)*90+45)*Math.PI/180+ar)*20*Math.sqrt(2),po.y*100+Math.sin(((i+1)*90+45)*Math.PI/180+ar)*20*Math.sqrt(2));
            }
            spr.graphics.drawRect(-465/2,-465/2,465,10);
            spr.graphics.drawRect(-465/2,465/2,465,-10);
            spr.graphics.drawRect(-465/2,-465/2,10,465);
            spr.graphics.drawRect(465/2,-465/2,-10,465);
        }
        public function MouseDown(e:MouseEvent):void{
            if(!mj){
                var vec:b2Vec2=new b2Vec2(e.stageX/100-465/200,e.stageY/100-465/200);
                if (shape.TestPoint(shape.GetBody().GetXForm(),vec)){
                    var mjd:b2MouseJointDef=new b2MouseJointDef();
                    mjd.maxForce=10;
                    mjd.body1=world.GetGroundBody();
                    mjd.body2=shape.GetBody();
                    mjd.target.Set(e.stageX/100-465/200,e.stageY/100-465/200);
                    mj=world.CreateJoint(mjd) as b2MouseJoint;
                }
            }
        }
        public function MouseUp(e:MouseEvent):void{
            if(mj){
                world.DestroyJoint(mj);
                mj=null;
            }
        }
        public function MouseMove(e:MouseEvent):void{
            if(mj)mj.SetTarget(new b2Vec2(e.stageX/100-465/200,e.stageY/100-465/200));
        }
    }
}