/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hUoL
 */

// forked from zendenmushi's MultiTouch テスト
package  
{
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.TouchEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.ui.Multitouch;
    import flash.ui.MultitouchInputMode;
    import frocessing.core.F5BitmapData2D;
    /**
     * ...
     * @author ...
     */
    
    [SWF(width=465,height=465,backgroundColor=0,frameRate=60)]
    public class MTTest extends Sprite
    {
        private var canvas : F5BitmapData2D;
        private var blur : BlurFilter = new BlurFilter(2, 2);
        private var glow : GlowFilter = new GlowFilter(0xffff80);
        private var colortransform : ColorTransform = new ColorTransform(0.999, 0.999, 0.999);
        private var zeroPoint : Point = new Point(0, 0);
        
        private var txt : TextField = new TextField;
        private var keystate : Array = [false, false, false, false, false ];
        private var mousestate : Array = [false, false, false, false, false ];
        
        private var touches : Object = { };
        
        
        public function MTTest() 
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeydown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyup);
            
            Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
            stage.addEventListener(TouchEvent.TOUCH_BEGIN, touchBegin);
            stage.addEventListener(TouchEvent.TOUCH_MOVE, touchMove);
            stage.addEventListener(TouchEvent.TOUCH_END, touchEnd);
            
            canvas = new F5BitmapData2D(stage.stageWidth, stage.stageHeight, true, 0);
            addChild(new Bitmap(canvas.bitmapData));
            addChild(txt);
            txt.text = Multitouch.maxTouchPoints.toString();
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(e:Event):void 
        {
            canvas.bitmapData.colorTransform(canvas.bitmapData.rect,  colortransform);
            canvas.bitmapData.applyFilter(canvas.bitmapData, canvas.bitmapData.rect, zeroPoint, blur);
            
            canvas.beginDraw();
            canvas.strokeWeight(4);
            
            for each(var touch : TouchPoint in touches) {
                if (touch) {
                    switch (touch.id) {
                        case 0: canvas.stroke(0x80, 0xff, 0x80); break;
                        case 1: canvas.stroke(0x80, 0x80, 0xff); break;
                        case 2: canvas.stroke(0xff, 0x80, 0xff); break;
                        case 3: canvas.stroke(0xff, 0xff, 0x80); break;
                        case 4: canvas.stroke(0xff, 0x80, 0x80); break;
                    }
                    canvas.moveTo(touch.bef_x, touch.bef_y);
                    canvas.lineTo(touch.x, touch.y);
                    touch.done();
                }
            }
            
            canvas.endDraw();
        }
        
        // ダミーのタッチイベントを発生させる
        private function onKeyup(e:KeyboardEvent):void 
        {
            switch (e.keyCode) { // '1'..'5'
                case 49: case 50: case 51: case 52: case 53: keystate[e.keyCode-49] = false; break;
            }
        }
        
        private function onKeydown(e:KeyboardEvent):void 
        {
            switch (e.keyCode) { // '1'..'5'
                case 49: case 50: case 51: case 52: case 53: keystate[e.keyCode-49] = true; break;
            }
        }
        
        private function mouseDown(e:MouseEvent):void 
        {
            for (var id : int = 0; id < 5; id++) {
                if (keystate[id]) {
                    var dummyTouch : TouchEvent = new TouchEvent(TouchEvent.TOUCH_BEGIN, true, false, id, false, e.localX+id*16, e.localY, 1,1,1.0);
                    mousestate[id] = true;
                    touchBegin(dummyTouch);
                }
            }
        }
        
        private function mouseMove(e:MouseEvent):void 
        {
            for (var id : int = 0; id < 5; id++) {
                if (keystate[id] && mousestate[id]) {
                    var dummyTouch : TouchEvent = new TouchEvent(TouchEvent.TOUCH_MOVE, true, false, id, false, e.localX+id*16, e.localY, 1,1,1.0);
                    touchMove(dummyTouch);
                }
            }
        }
        
        private function mouseUp(e:MouseEvent):void 
        {
            for (var id : int = 0; id < 5; id++) {
                if (keystate[id]) {
                    var dummyTouch : TouchEvent = new TouchEvent(TouchEvent.TOUCH_END, true, false, id, false, e.localX+id*16, e.localY, 1,1,1.0);
                    mousestate[id] = false;
                    touchEnd(dummyTouch);
                }
            }
        }
        
        private function touchBegin(e:TouchEvent):void 
        {
            touches[e.touchPointID] = new TouchPoint(e.localX, e.localY, e.touchPointID);
        }
        
        private function touchMove(e:TouchEvent):void 
        {
            var touch : TouchPoint = touches[e.touchPointID];
            if (touch) {
                touch.x = e.localX;
                touch.y = e.localY;
            }
        }

        private function touchEnd(e:TouchEvent):void 
        {
            touches[e.touchPointID] = null;
        }
        
    }

}

class TouchPoint
{
    public var x : Number;
    public var y : Number;
    public var bef_x : Number;
    public var bef_y : Number;
    public var id : int;
    public var down_trigger : Boolean = false;
    
    public function TouchPoint(x : Number, y : Number, id : int)
    {
        this.x = x;
        this.y = y;
        this.bef_x = x;
        this.bef_y = y;
        this.id = id;
        this.down_trigger = true;
    }
    
    public function done() : void
    {
        this.bef_x = this.x;
        this.bef_y = this.y;
        this.down_trigger = false;
    }
}