/**
 * Copyright ta1 ( http://wonderfl.net/user/ta1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hUgj
 */

// forked from mousepancyo's Mosaic Camera
package  {
    import flash.display.*;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    
    import jp.progression.commands.Func;
    import jp.progression.commands.Wait;
    import jp.progression.commands.lists.SerialList;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "15")]
    
    public class Main extends Sprite{
        
        private const GRID_SIZE:int = 10;
        private var _pixelSize:Number = GRID_SIZE * .9;
        private var _bmd:BitmapData;
        private var _pixels:Array;
        
        private var _container:Sprite = new Sprite();
        private var _dots:Array = [];
        
        private var _cam:Camera;
        private var _video:Video;
        private var _matrix:Matrix;
        
        public function Main()
        {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x606060)));
            setup();
            addChild(_container);
        }
        
        private function setup():void
        {
            _video = new Video(320, 240);
            setupCamera(_video, 320, 240, 15);
            _matrix = new Matrix(-2, 0, 0, 2, 640 - 87);
        }
        
        private function setupCamera(video:Video, cX:int = 640, cY:int = 480, fps:Number = 5):void
        {
            var camX:int = cX
            var camY:int = cY
            _cam = new Camera()
            _cam = Camera.getCamera();
            _cam.setMode(camX,camY,fps);
            video.attachCamera(_cam);
            _cam.addEventListener(ActivityEvent.ACTIVITY, camActive);
        }
        
        private function camActive(e:ActivityEvent):void
        {
            _cam.removeEventListener(ActivityEvent.ACTIVITY, camActive);
            _bmd = new BitmapData(465, 465);
            _bmd.draw(_video, _matrix);
            createPixels(_bmd);
            addDots(_pixels);
            //
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            _bmd.draw(_video, _matrix);
            createPixels(_bmd);
            for(var i:int=0; i<_pixels.length; i++){
                for(var j:int=0; j<_pixels[i].length; j++){
                    _dots[i][j].changeColor(_pixels[i][j]);
                }
            }
        }
        
        private function createPixels(bmd:BitmapData):void
        {
            _pixels = [];
            for(var i:int=0; i<_bmd.width; i+=GRID_SIZE){
                var list:Array = [];
                for(var j:int=0; j<_bmd.height; j+=GRID_SIZE){
                    list.push(_bmd.getPixel(i, j));
                }
                _pixels.push(list);
            }
        }
        
        private function addDots(pixels:Array):void
        {
            
            for(var i:int=0; i<pixels.length; i++){
                var list:Array = [];
                for(var j:int=0; j<pixels[i].length; j++){
                    var dot:Dot = new Dot(i * GRID_SIZE, j * GRID_SIZE, _pixelSize * .5, pixels[i][j]);
                    dot.scaleX = dot.scaleY = -.6;
                    dot.x = Math.random() * 5000 - 2000;
                    dot.y = Math.random() * 5000 - 2000;
                    dot.alpha = 0;
                    tween(dot, 6, i * GRID_SIZE, j * GRID_SIZE, 1, j * .05 + 1)
                    _container.addChild(dot);
                    //
                    list.push(dot);
                }
                _dots.push(list);
                stage.addEventListener(MouseEvent.CLICK, onDown);
            }
        }
        
        private function onDown(e:MouseEvent):void
        {
            var slist:SerialList = new SerialList();
            slist.addCommand(
                function():void{stage.removeEventListener(MouseEvent.CLICK, onDown);},
                new Func(pixBreak),
                new Wait(4),
                function():void{_cam.addEventListener(ActivityEvent.ACTIVITY, onActive);}
                )
            slist.execute();
        }
        
        private function pixBreak():void
        {
            for(var i:int=0; i<_dots.length; i++){
                for(var j:int=0; j<_dots[i].length; j++){
                    var tx:Number = Math.random() * 2000 - 1000;
                    var ty:Number = Math.random() * 2000 - 1000;
                    //
                    var tween:ITween = BetweenAS3.tween(_dots[i][j], { x:tx, y:ty, scaleX:-.6, scaleY:-.6, alpha:0 }, null, 3, Quart.easeIn);
                    tween = BetweenAS3.delay(tween, j * .01);
                    tween.play();
                }
            }
        }
        
        private function pixReBuild():void
        {
            for(var i:int=0; i<_dots.length; i++){
                for(var j:int=0; j<_dots[i].length; j++){
                    tween(_dots[i][j], 5, i * GRID_SIZE, j * GRID_SIZE, 1, j * .03 + 1);
                }
            }
        }
        
        private function onActive(e:ActivityEvent):void
        {
            if(_cam.activityLevel < 10) return;
            var slist:SerialList = new SerialList();
            slist.addCommand(
                function():void{_cam.removeEventListener(ActivityEvent.ACTIVITY, onActive);},
                new Func(pixReBuild),
                new Wait(5),
                function():void{stage.addEventListener(MouseEvent.CLICK, onDown);}
            )
            slist.execute();
        }
                
        private function tween(target:DisplayObject, time:Number, px:Number, py:Number, a:Number = 1, delay:Number=0):void
        {
            var tween:ITween = BetweenAS3.tween(target, { x:px, y:py, scaleX:1, scaleY:1, alpha:a }, null, time, Quart.easeOut);
            tween = BetweenAS3.delay(tween, delay);
            tween.play();
        }
        
    }
    
}


// ----------- Class Dot ----------------------------------/

import flash.display.Graphics;
import flash.display.Sprite;

internal class Dot extends Sprite
{
    private var _size:Number;
    
    public function Dot(px:Number, py:Number, size:Number, col:int)
    {
        _size = (size * (Math.random() * .3 + .2));
        graphics.beginFill(col);
        graphics.drawCircle(0, 0, _size);
        this.x = px;
        this.y = py;
    }
    
    public function changeColor(col:int):void
    {
        graphics.clear();
        graphics.beginFill(col);
        graphics.drawCircle(0, 0, _size);
    }
}
