/**
 * Copyright masamunet ( http://wonderfl.net/user/masamunet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hTql
 */

/*
 * なんかTwitterで流行ってるみたいなので作ってみた。
 * 根が面倒くさがりなので基本的なとこを適当に。
 */
package {
    import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.net.*;
	import flash.utils.*;
    public class FlashTest extends Sprite {
		private const TITLE:String = "サーチエンジン";
		private const URL:String = "http://wonderfl.net/code/7d68db6fc691d168b2f326339afea87146d3d503";
		private const RESULT:/*String*/Array = [
			"Google",
			"Yahoo!",
			"MSN",
			"infoseek",
			"isize",
			"excite",
			"goo",
			"おちゃらナビ",
			"百度",
			"手動サーチエンジンはやぶさ"
		];
        public function FlashTest() {
            // write as3 code here..
            addEventListener(Event.ADDED_TO_STAGE, function(e:Event):void {
				var t0:TextField = new TextField();
				t0.text = TITLE + "占い的な文言。";
				t0.x = 0.0;
				t0.y = 0.0;
				t0.width = stage.stageWidth;
				addChild(t0);
				var t1:TextField = new TextField();
				t1.text = "あなたのTwitterのIDをここに入れてみよう的な文言。";
				t1.x = 0.0;
				t1.y = 20.0;
				t1.width = stage.stageWidth;
				addChild(t1);
				var t2:TextField = new TextField();
				t2.x = 0.0;
				t2.y = 40.0;
				t2.width = 50.0;
				t2.text = "id:";
				addChild(t2);
				
				
				var inputId:TextField = new TextField();
				inputId.width = 150.0;
				inputId.height = 20.0;
				inputId.x = 50.0;
				inputId.y = 40.0;
				inputId.border = true;
				inputId.type = TextFieldType.INPUT;
				inputId.maxChars = 50;
				addChild(inputId);
				
				var t:TextField = new TextField();
				t.width = stage.stageWidth - 1.0;
				t.height = 60.0
				t.y = 100.0;
				t.border = true;
				t.multiline = true;
				t.text = "ここに占いの結果が表示されます的な文言。";
				addChild(t);
				
				var submitButton:Sprite = createButton("占う");
				submitButton.x = 50.0;
				submitButton.y = 70.0;
				addChild(submitButton);
				var str:String;
				submitButton.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
					if(inputId.text.length !== 0){
						var r:int;
						var l:int = inputId.text.length;
						for (var i:int = 0; i < l; i++) 
						{
							r += inputId.text.charCodeAt(i);
						}
						str = RESULT[r % RESULT.length];
						t.text = "あなたにぴったりの " + TITLE + " は\r" + str + " です！";
					}else {
						t.text = "TwitterのIDを入れてね！的な文言。";
					}
				});
				
				var twitter:Sprite = createButton("結果をTwitterでつぶやく");
				twitter.x = (stage.stageWidth - twitter.width) * 0.5;
				twitter.y = 170.0;
				addChild(twitter);
				twitter.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
					if(inputId.text.length !== 0){
						var param:String = ".@" + inputId.text + "さんにぴったりの " + TITLE + " は " + str + " です。 [Twitter " + TITLE + " 占い基本パック] " + URL;
						navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(param)), "_blank");
					}
				});
			});
        }
		private function createButton(txt:String):Sprite {
			var sp:Sprite = new Sprite();
			var t:TextField = new TextField();
			t.selectable = false;
			t.autoSize = TextFieldAutoSize.LEFT
			t.text = txt;
			sp.addChild(t);
			var g:Graphics = sp.graphics;
			g.beginFill(0xCCCCCC);
			g.drawRect(0, 0, t.width, t.height);
			g.endFill();
			return sp;
		}
    }
}