/**
 * Copyright adamh ( http://wonderfl.net/user/adamh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hTJA
 */

// forked from adamh's Flash block tester
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.LoaderInfo;
    import flash.text.TextField;
    
    import flash.utils.*;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.geom.Rectangle;
    
    public class FlashTest extends Sprite {
        private var text_items:Array = new Array();
        private var clicked_spr:Sprite = new Sprite();
        private var clicked_txt:TextField = new TextField();
        
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var paramObj:Object = LoaderInfo(this.root.loaderInfo).parameters,
                tmp_text:TextField;
            
            for(var param:String in paramObj){
                tmp_text = new TextField();
                tmp_text.text = param + ' : ' + String(paramObj[param]);
                tmp_text.height = 30;
                text_items.push(addChild(tmp_text));
            }
            
            clicked_spr.visible = false;
            
            clicked_txt.height = 40;
            clicked_txt.text = "CLICKED";
            clicked_spr.addChild(clicked_txt);
            addChild (clicked_spr);
            
            layout();
            stage.addEventListener(Event.RESIZE, layout);
            stage.addEventListener(MouseEvent.CLICK, function():void {
                clicked_spr.visible = true;
                
                clicked_spr.graphics.beginFill(0x888888);
                clicked_spr.graphics.drawRect(0, 0, clicked_spr.width, clicked_spr.height);
                clicked_spr.graphics.endFill();
                
                clicked_spr.width = stage.stageWidth / 2;
                clicked_spr.height = stage.stageHeight / 2;
                clicked_spr.x = stage.stageWidth / 4;
                clicked_spr.y = stage.stageHeight / 4;
                
                setTimeout(function():void { clicked_spr.visible = false; }, 1000);
            });
        }
        
        private function layout(e:Event = null):void {            
            graphics.beginFill(0xFF0000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            graphics.beginFill(0x00FFEE);
            graphics.drawRect(0,0, stage.stageWidth, stage.stageHeight / 2);
            graphics.endFill();
            
            for(var i:int = 0; i < text_items.length; i++) {
                graphics.beginFill(0x00FF22);
                graphics.drawRect(stage.stageWidth / 6,40*(i+1), stage.stageWidth / 1.5, 30);
                graphics.endFill();
                text_items[i].width = stage.stageWidth / 1.5;
                text_items[i].x = stage.stageWidth / 6;
                text_items[i].y = 40 * (i + 1);
            }

        }
    }
}