/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/hT9U
 */

// forked from YoupSolo's Flash Tip Collection - Tip 2 - Flash style easing method
package
{
    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    public class Main extends Sprite
    {
        private const FRAMERATE:int = 90;
        private const EASING_FACTOR:Number = 0.09;
        private var   _path:Array;        
        private var   _shape:Sword;
        
        public function Main():void
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // config stage
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.MEDIUM;
            stage.stageFocusRect = false;
            stage.tabChildren = false;
            stage.frameRate = FRAMERATE;
            
            this.graphics.beginFill(0x333333);
            this.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();               
            
            
            // add custom menu
            new CustomMenu(this);
            
            // run app            
            run();
        
        }
        
        private function run():void
        {
            // display the result using Point.distance(p1,p2); static method
            buildTextField(this, 'TIP 2 : Flash Style easing method');
            buildTextField(this, 'obj.myProperty += (targetValue - obj.myProperty) * EASING_FACTOR;', 0, 18);            
            
            _path = [new Point(180, 180), new Point(180, 325), new Point(300, 300), new Point(300, 180)];
            
            //_shape = new Polygon(32, 6, new XORTexture(64, 64, 0x808080)); // XORTexture is a bitmapData
            _shape = new Sword();
            _shape.x = (_path[0] as Point).x;
            _shape.y = (_path[0] as Point).y;
            _shape.rotation = 90;
            _shape.filters = [new DropShadowFilter()];
            addChild(_shape);
            
            // my update loop
            this.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        private function _onEnterFrame(e:Event):void
        {
            var destPoint:Point = _path[1] as Point;
            var distanceX:Number = destPoint.x - _shape.x;
            var distanceY:Number = destPoint.y - _shape.y;
            var distance:Number = Point.distance(destPoint, _shape.position); // http://wonderfl.net/c/leaD ;)       
            // -- flash style easing method
            _shape.x += (distanceX * EASING_FACTOR);
            _shape.y += (distanceY * EASING_FACTOR);            
            _shape.rotation += (distance * EASING_FACTOR);
            // -- changing the dest point
            if (distance < 1) {
                _path.push(_path.shift());
            }
        }

        private function buildTextField(doc:DisplayObjectContainer, txt:String, x:int = 0, y:int = 0):TextField
        {
            var fmt:TextFormat = new TextFormat;
            fmt.color = 0xFFFFFF;
            fmt.font = 'Arial';
            fmt.size = 11;
            
            var tf:TextField = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.opaqueBackground = 0x333333; // opaque background allow a perfect font rendering even in StageQuality.LOW mode
            tf.selectable = false;
            tf.defaultTextFormat = fmt;
            tf.text = txt;
            tf.x = x;
            tf.y = y;
            
            doc.addChild(tf);
            
            return tf;
        }
    
    }

}
import flash.geom.Matrix;

import flash.display.Shape;
import flash.display.Graphics;
import flash.geom.Point;
internal class Sword extends Shape
{
    private var pen:Graphics;
    private var array:Array=[ [55,0],
        [55,50],
        [20,50],
        [20,60],
        [50,60],
        [50,300],
        [60,340],
        [70,300],
        [70,60],
        [100,60],
        [100,50],
        [65,50],
        [65,0],
        [55,0]
    ];
    public function Sword()
    {
        var tex:BitmapData = new XORTexture(96,96,0x800000)
        this.cacheAsBitmap = true;
        pen = this.graphics;
        pen.moveTo(array[0][0]-60, array[0][1]-95);
        pen.beginBitmapFill( tex , null, true, true)
        var len:int = array.length;
        for (var i:int=0; i<len; i++)
        {
            pen.lineTo(array[i][0]-60, array[i][1]-95);
        }
        pen.endFill();
        
        pen.beginBitmapFill( tex , new Matrix(.1,0,0,.1,0,0), false, true)
        pen.drawCircle(0, -40, 20);
        pen.drawCircle(0, -40, 16);
        pen.endFill();
        
        this.scaleX = this.scaleY = 0.5;
    }
    
    public function get position():Point
    {
        return new Point(this.x, this.y);
    }    
}

import flash.display.BitmapData;

internal class XORTexture extends BitmapData
{
    
    public function XORTexture(width:int, height:int, coul:uint)
    {
        super(width, height, false, 0x0);
        
        for (var w:int = 0; w < width; w++)
        {
            for (var h:int = 0; h < height; h++)
            {
                var coul256:uint = w ^ h;
                var red:int = Math.max((coul >> 16 & 0xff) - coul256, 0);
                var green:int = Math.max((coul >> 8 & 0xff) - coul256, 0);
                var blue:int = Math.max((coul & 0xff) - coul256, 0);
                var color:uint = red << 16 | green << 8 | blue;
                this.setPixel(w, h, color);
            }
        }
    }
}

import flash.display.Sprite;
import flash.events.ContextMenuEvent;
import flash.net.navigateToURL;
import flash.net.URLRequest;
import flash.ui.ContextMenu;
import flash.ui.ContextMenuItem;

internal class CustomMenu
{
    
    private const NAME:String = "Flash Tips Collection : 'Flash-Style' easing method";
    
    public function CustomMenu(ref:Sprite):void
    {
        var appContextMenu:ContextMenu = new ContextMenu;
        appContextMenu.hideBuiltInItems();
        
        var cmi:ContextMenuItem = new ContextMenuItem(NAME);
        var credits:ContextMenuItem = new ContextMenuItem("by YopSolo");
        appContextMenu.customItems.push(cmi);
        appContextMenu.customItems.push(credits);
        
        cmi.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCollection);
        credits.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCredits);
        
        ref.contextMenu = appContextMenu;
    }
    
    private function _onClickCollection(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr/wp/2012/01/14/flash-tips-collection/'), '_blank');
    }
    
    private function _onClickCredits(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr'), '_blank');
    }
}