/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hT8b
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        
        private var _canvas:BitmapData;
        private var _canvasbmp:Bitmap;
        
        private var _particles:Vector.<Particle>;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            _canvasbmp = new Bitmap();
            addChild( _canvasbmp );
            
            Reset();
            
           
            addEventListener(Event.ENTER_FRAME, Update);
        }
        
        private function Reset() : void
        {
            if ( _canvas )    _canvas.dispose();
            _canvas = new BitmapData( WIDTH, HEIGHT, false, 0 );
            _canvasbmp.bitmapData = _canvas;
            
            
            _particles = new Vector.<Particle>( PARTICLE_NUM, true );
            
            var i:int;
            var p:Particle;
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                var anglerad:Number = Math.random() * PI2;
                var vx:Number = Math.cos( anglerad ) * 3;
                var vy:Number = Math.sin( anglerad ) * 3;
                p = new Particle( Math.random() * WIDTH, Math.random() * HEIGHT, vx, vy );    
                _particles[i] = p;
            }
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                p = _particles[i];
                p.target = _particles[int(Math.random() * PARTICLE_NUM)];
            }
        }
        
        private function Update(e:Event) : void
        {
            var i:int;
            var p:Particle, t:Particle;
            var mx:Number = stage.mouseX;
            var my:Number = stage.mouseY;
           
            _canvas.lock();
            _canvas.fillRect( _canvas.rect, 0xFFFFFF );
            for ( i = 0; i < PARTICLE_NUM; i++ )
            {
                p = _particles[i];
                t = _particles[i].target;
                
                if ( (p.x - mx) * (p.x - mx) + (p.y - my) * (p.y - my) < 50 * 50 )
                {
                    p.vx = p.vx + (mx - p.x) / 100;
                    p.vy = p.vy + (my - p.y) / 100;
                }else
                {
                    p.vx = p.vx + (p.x - t.x) / 10000;
                    p.vy = p.vy + (p.y - t.y) / 10000;
                }

                p.x += p.vx;
                p.y += p.vy;
                
                var sp:Number = Math.sqrt( (p.vx * p.vx) + (p.vy * p.vy) )
                if ( sp > 5 )
                {
                    p.vx /= sp * 5;
                    p.vy /= sp * 5;
                }                
                
                if ( p.x < 0 )    p.x = WIDTH - (p.x % WIDTH);
                else if ( p.x >= WIDTH ) p.x = p.x % WIDTH;
                if ( p.y < 0 ) p.y = HEIGHT - (p.y % HEIGHT);
                else if ( p.y >= HEIGHT ) p.y = p.y % HEIGHT;
                
                _canvas.setPixel( p.x, p.y, 0 );
                _canvas.setPixel( p.x+1, p.y, 0 );
                _canvas.setPixel( p.x-1, p.y, 0 );
                _canvas.setPixel( p.x, p.y + 1, 0 );
                _canvas.setPixel( p.x, p.y - 1, 0 );
            }
            _canvas.unlock();
        }
       
    }
    
}
const PI2:Number = 3.141592653589793 * 2;
const WIDTH:int = 465;
const HEIGHT:int = 465;
const PARTICLE_NUM:int = 300;

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    
    public var target:Particle;
    
    public function Particle(x:Number, y:Number, vx:Number, vy:Number) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
    }
}
