/**
 * Copyright earl223 ( http://wonderfl.net/user/earl223 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hSuY
 */

package  {
    
    // @author Earl Andre Vergara
    // Submitted for 2011 Phlashers.com 5KB Challenge
    
    // Basic Map Maker Demo
    // - Click on tiles to drag them up or down
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.MovieClip;
    import flash.geom.Point;
    
    [SWF(backgroundColor="0xFFFFFF", width="600", height="600")]
    public class MapMaker extends MovieClip {
        
        private var _rows:int = 10;
        private var _cols:int = 10;
        private var displacement:int = 0;
        private var xMouse:Number;
        private var yMouse:Number;
        private var row:int = 0;
        private var col:int = 0;
        private var tileHolder:MovieClip = new MovieClip;
        private var selected:MovieClip = null;
        
        public function MapMaker() {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void { 
            // add tile holder
            addChild(tileHolder);
            
            // create map grid
            for (row = 0; row < _rows; row++) {
                for (col = 0; col < _cols; col++) {
                    var tile:MovieClip = new MovieClip;
                    tile.graphics.lineStyle(2, 0x336600);
                    tile.graphics.beginFill(0x66CC00);
                    tile.graphics.moveTo(0,-15);
                    tile.graphics.lineTo(30,0);
                    tile.graphics.lineTo(0,15);
                    tile.graphics.lineTo(-30,0);
                    tile.graphics.lineTo(0,-15);
                    tile.graphics.endFill();
                    tile.x = (300 - (tile.width / 2 * col)) + (tile.width / 2 * row);
                    tile.y = (250 + (15 * row)) + (15 * col);
                    tile.tile = {x:0, y:0};
                    tile.level = 0;
                    tile.name = "tile_" + row + "_" + col;
                    tile.mouseEnabled = true;
                    tileHolder.addChild(tile);
                }
            }
            tileHolder.mouseEnabled = false;
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, selectTile);
            stage.addEventListener(MouseEvent.MOUSE_UP, releaseTile);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveTile); 
        }
        
        
        private function selectTile(e:MouseEvent):void { 
            if (e.target.name) {
               if (e.target.name.indexOf("tile") >= 0) selected = e.target as MovieClip;
            }
        }
        
        private function releaseTile(e:MouseEvent):void {
            selected = null; 
        }
        
        private function moveTile(e:MouseEvent):void {
            xMouse = e.stageX;
            yMouse = e.stageY;
            if (selected) {
                var point:Point = selected.globalToLocal(new Point(xMouse, yMouse));
                var displace:int = point.y / 5;
                if (displace <= 0) {
                    selected.level = displace * 5;
                    if (selected.level < -150) selected.level = -150;
                    selected.tile.y = selected.level;
                    
                    // create ground
                    selected.graphics.clear();
                    selected.graphics.lineStyle(1, 0x336600);
                    selected.graphics.beginFill(0x66CC00);
                    selected.graphics.moveTo(0, selected.tile.y -15);
                    selected.graphics.lineTo(30,selected.tile.y);
                    selected.graphics.lineTo(0,selected.tile.y + 15);
                    selected.graphics.lineTo(-30,selected.tile.y);
                    selected.graphics.lineTo(0,selected.tile.y -15);
                    selected.graphics.endFill();
                    selected.graphics.lineStyle(1, 0x996600);
                    selected.graphics.beginFill(0x996600);
                    selected.graphics.moveTo(0, 30);
                    selected.graphics.lineTo(0, selected.tile.y + 15);
                    selected.graphics.lineTo(-selected.width / 2, selected.tile.y);
                    selected.graphics.lineTo(-selected.width / 2, 0);
                    selected.graphics.lineTo(0, 15);
                    selected.graphics.endFill();
                    selected.graphics.beginFill(0x663300);
                    selected.graphics.lineTo(0, selected.tile.y + 15);
                    selected.graphics.lineTo(selected.width / 2, selected.tile.y);
                    selected.graphics.lineTo(selected.width / 2, 0);
                    selected.graphics.lineTo(0, 15);
                    selected.graphics.endFill();
                }
            }
            stage.focus = stage;
        }

    }
    
}