/**
 * Copyright weBBBBB ( http://wonderfl.net/user/weBBBBB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hSm2
 */

package {
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.display.StageAlign;
	import flash.display.StageDisplayState;
	import flash.display.StageScaleMode;
	
	public class BlogParts extends Sprite {
		// 枝を伸ばす角度
		private var angle:Number = 40;
		// 子枝と親枝の比率
		private var scale:Number = 0.8;
		// 枝の長さ
		private var len:Number = -300;
		// 枝の色
		private var treeColor:uint = 0x372A26;
		// 枝の太さ
		private var thickness:Number = 20;
		// 枝の数
		private var _num:uint = 0;
		// 枝の最大数
		private var maxBranch:uint = Math.random() * 600 + 2;
		// カラーリスト
		private var colorList:Array = [ Math.random() * 0xffffff, ];
		// カラーを格納する配列
		private var cList:Array = new Array();
		
		//コンストラクタ
		public function BlogParts() 
		{
			stage.align        = StageAlign.TOP_LEFT;
			stage.scaleMode    = StageScaleMode.NO_SCALE;
			stage.displayState = StageDisplayState.FULL_SCREEN;
			
			// 木の幹を生成
			var trunk:MovieClip = new MovieClip();
			var trunk2:MovieClip = new MovieClip();
			var trunk3:MovieClip = new MovieClip();
			trunk.x = stage.stageWidth / 2;
			trunk.y = stage.stageHeight;
			trunk.cy = 0;
			trunk.ey = len;
			
			trunk2.x = stage.stageWidth / 2 * Math.random();
			trunk2.y = stage.stageHeight + 100;
			trunk2.cy = 10;
			trunk2.ey = len;
			
			
			
			// 表示リストに追加
			addChild( trunk );
			addChild( trunk2 );
			
			
			// HTMLからパラメータを取得し、木の実のカラーを設定する
			setColorList();
			
			// trunkオブジェクトのフレームが再生されるたびにonGrowBranchを実行
			trunk.addEventListener( Event.ENTER_FRAME, onGrowBranch );
			trunk2.addEventListener( Event.ENTER_FRAME, onGrowBranch );
			trunk3.addEventListener( Event.ENTER_FRAME, onGrowBranch );
			
		}
		
		
		private function setColorList():void {
			// パラメータからcolorNoを取得
			var paramObj:Object= loaderInfo.parameters;
			var colorNo:int = int( paramObj[ "colorNo" ] );
			
			// colorNoの値で色を決定　0～5：各色　6：全色
			if( colorNo < colorList.length ){
				cList[ 0 ] = colorList[ colorNo ];
			}
			else{
				cList = colorList;
			}
		}
		
		// 枝を伸ばす
		private function onGrowBranch( evt:Event ):void {
			var branch:MovieClip = evt.currentTarget as MovieClip;
			var branch2:MovieClip = evt.currentTarget as MovieClip;
			
			if( Math.abs( branch.ey - branch.cy ) < 1 , Math.abs( branch2.ey - branch2.cy ) < 5 ){
				// 処理を停止
				branch.cy = branch.ey;
				branch.removeEventListener( Event.ENTER_FRAME, onGrowBranch );
				if( _num < maxBranch ){
					// 枝を作成
					createBranch( branch, branch.cy );
					createBranch( branch2, branch2.cy );
				}
				else{
					// 実を作成
					createFruit( branch );
					createFruit( branch2 );
				}
			}
			else{
				// イージングでY座標を設定
				branch.cy += ( branch.ey - branch.cy ) * 0.2;
			}
			
			// 枝を描画
			branch.graphics.clear();
			branch.graphics.lineStyle( thickness, treeColor, 100 );
			branch.graphics.moveTo( 0, 0 );
			branch.graphics.lineTo( 0, branch.cy );
			
			
			branch2.graphics.clear();
			branch2.graphics.lineStyle( thickness, treeColor, 50 );
			branch2.graphics.moveTo( 0, 0 );
			branch2.graphics.lineTo( 0, branch2.cy );
		}
		
		// 枝を作成
		private function createBranch( targetmc:MovieClip, sy:Number ):void {
			// 親枝から伸ばす子枝の本数
			var n:int = 2;
			var rot:Number = Math.random() * angle + 10;
			for ( var i:int = 0; i < n; i++ ) {
				// 枝を生成
				var branch:MovieClip = new MovieClip();
				branch.y = sy;
				branch.rotation = rot * Math.pow( -1, i );
				branch.scaleX = branch.scaleY = scale;
				branch.cy = 0;
				branch.ey = Math.random() * len - 15;
				
				// branchをムービークリップtargetmcに追加
				targetmc.addChild( branch );
				// 枝の数をカウント
				_num++;
				
				// branchオブジェクトのフレームが再生されるたびにonGrowBranchを実行
				branch.addEventListener( Event.ENTER_FRAME, onGrowBranch );
			}
		}
		
		// 実を作成
		private function createFruit( branch:MovieClip ):void {
			// 実を生成
			var fruit:MovieClip = new MovieClip();
			
			// 実の位置を設定
			var localpt:Point = new Point( branch.x, branch.cy );
			var pt:Point = branch.localToGlobal( localpt );
			var fpt:Point = Point.polar( Math.random() * 35, Math.random() * Math.PI  * 2 );
			fruit.x = pt.x + fpt.x;
			fruit.y = pt.y + fpt.y;
			fruit.alpha = 0;
			
			// パラメータを設定
			var radius:Number = Math.random() * 50 + 3;
			var color:uint = cList[ uint( Math.random() * cList.length ) ];
			var alp:Number = Math.random() * 0.5;
			
			// 実を描画
			fruit.graphics.beginFill( color, alp );
			fruit.graphics.drawCircle( 0, 0, radius );
			fruit.graphics.endFill();
			
			// 表示リストに追加
			addChild( fruit );
			
			// fruitオブジェクトのフレームが再生されるたびにonGrowFruitを実行
			fruit.addEventListener( Event.ENTER_FRAME, onGrowFruit );
		}
		
		// 実をフェードインする
		private function onGrowFruit( evt:Event ):void {
			var fruit:MovieClip = evt.currentTarget as MovieClip;
			
			if( Math.abs( 1 - fruit.alpha ) < 0.1 ){
				// 処理を停止
				fruit.removeEventListener( Event.ENTER_FRAME, onGrowFruit );
			}
			else{
				// イージングでアルファを設定
				fruit.alpha += ( 1 - fruit.alpha ) * 0.05;
			}
		}
	}
}

