/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hSju
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.render.QuadrantRenderEngine;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.stats.StatsView;
    
    [SWF(backgroundColor = 0x000000)]
    public class Main extends ReflectionView
    {
        
        private var cameraRots:Number = 0;
        private var cameraRott:Number = 0;
        
        private var diceArray:Array;
        
        private var count:int;
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            addChild(new StatsView(renderer));
            
            surfaceHeight = 0;
            viewportReflection.filters = [new BlurFilter(4, 4)];
            viewportReflection.alpha = 0.7;
            
            //renderer = new QuadrantRenderEngine(QuadrantRenderEngine.QUAD_SPLIT_FILTER);
            
            diceArray = new Array();
            
            var die:Dice = new Dice();
            die.y = 50;
            scene.addChild(die);
            
            count = 0;
            addEventListener(Event.ENTER_FRAME, onUpdate);
        }
        
        private function onUpdate(e:Event):void 
        {
            updateCamera();
            
            count++;
            if (count % 10 == 0)
            {
                var die:Dice = new Dice();
                scene.addChild(die);
                die.y = 1000;
                var a:Number = Math.random() * Math.PI * 2;
                var r:Number = Math.random() * 1000;
                die.x = Math.cos(a) * r;
                die.z = Math.sin(a) * r;
                die.rotationX = Math.random() * 360;
                die.rotationY = Math.random() * 360;
                die.rotationZ = Math.random() * 360;
                diceArray.push(die);
            }
            
            for (var i:int = 0; i < diceArray.length; i++)
            {
                diceArray[i].y -= 10;
                if (diceArray[i].y < 50)
                {
                    scene.removeChild(diceArray[i]);
                    diceArray.splice(i, 1);
                    i--;
                }
            }
            
            singleRender();
        }
        
        private function updateCamera():void
        {
            var s:Number = (mouseX / stage.stageWidth) * Math.PI*2;
            var t:Number = (mouseY / stage.stageHeight) * Math.PI/2;
            s = cameraRots += (s - cameraRots) * 0.1;
            t = cameraRott += (t - cameraRott) * 0.1;
            _camera.x = (Math.cos(s) * Math.cos(t) * 1000);
            _camera.y = Math.sin(t) * 1000;
            _camera.z = Math.sin(s) * Math.cos(t) * 1000;
        }
        
    }
    
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import org.papervision3d.materials.BitmapFileMaterial;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.primitives.Cube;
class Dice extends Cube
{
    private static var materials:MaterialsList;
    
    public function Dice()
    {
        if (materials == null) init();
        super(materials, 100, 100, 100);
    }
    
    private function init():void
    {
        var pocchi:Sprite = new Sprite();
        
        var matrixC:Matrix = new Matrix();
        matrixC.translate(50, 50);
        var matrixUL:Matrix = new Matrix();
        matrixUL.translate(19, 19);
        var matrixUR:Matrix = new Matrix();
        matrixUR.translate(81, 19);
        var matrixDL:Matrix = new Matrix();
        matrixDL.translate(19, 81);
        var matrixDR:Matrix = new Matrix();
        matrixDR.translate(81, 81);
        
        var rectAll:Rectangle = new Rectangle(0, 0, 100, 100);
        var smoke:BitmapData = new BitmapData(100, 100, true, 0);
        smoke.perlinNoise(30, 30, 1, 10, false, true, 8, true);
        smoke.colorTransform(rectAll, new ColorTransform(1, 1, 1, 0.3));
        
        pocchi.graphics.beginFill(0xFF0000);
        pocchi.graphics.drawCircle(0, 0, 14);
        var f1:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0xFFFFFF), true);
        f1.bitmap.draw(pocchi, matrixC);
        f1.bitmap.draw(smoke, null, null, "subtract");
        
        pocchi.graphics.clear();
        pocchi.graphics.beginFill(0x666666);
        pocchi.graphics.drawCircle(0, 0, 12);
        
        var f2:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0xFFFF00), true);
        f2.bitmap.draw(pocchi, matrixUL);
        f2.bitmap.draw(pocchi, matrixDR);
        f2.bitmap.draw(smoke, null, null, "subtract");
        
        var f3:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0x8080FF), true);
        f3.bitmap.draw(pocchi, matrixUR);
        f3.bitmap.draw(pocchi, matrixC);
        f3.bitmap.draw(pocchi, matrixDL);
        f3.bitmap.draw(smoke, null, null, "subtract");
        
        var f4:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0x00FFFF), true);
        f4.bitmap.draw(pocchi, matrixUL);
        f4.bitmap.draw(pocchi, matrixUR);
        f4.bitmap.draw(pocchi, matrixDL);
        f4.bitmap.draw(pocchi, matrixDR);
        f4.bitmap.draw(smoke, null, null, "subtract");
        
        var f5:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0x80FF80), true);
        f5.bitmap.draw(pocchi, matrixUL);
        f5.bitmap.draw(pocchi, matrixUR);
        f5.bitmap.draw(pocchi, matrixC);
        f5.bitmap.draw(pocchi, matrixDL);
        f5.bitmap.draw(pocchi, matrixDR);
        f5.bitmap.draw(smoke, null, null, "subtract");
        
        var f6:BitmapMaterial = new BitmapMaterial(new BitmapData(100, 100, false, 0xFF80FF), true);
        f6.bitmap.draw(pocchi, matrixUL);
        matrixC.identity();
        matrixC.translate(50, 19);
        f6.bitmap.draw(pocchi, matrixC);
        f6.bitmap.draw(pocchi, matrixUR);
        f6.bitmap.draw(pocchi, matrixDL);
        matrixC.identity();
        matrixC.translate(50, 81);
        f6.bitmap.draw(pocchi, matrixC);
        f6.bitmap.draw(pocchi, matrixDR);
        f6.bitmap.draw(smoke, null, null, "subtract");
        
        materials = new MaterialsList( {
                top:f1,
                front:f2,
                left:f3,
                right:f4,
                back:f5,
                bottom:f6
        });
    }
}