/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hSVi
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    
    /**
     * ...
     * @author gaina
     * 詳解 ActionScript 3.0アニメーションのやつ
     * 肌色検知
     */
    [SWF(width="465",height="465")]
    public class CameraTest extends Sprite 
    {
        
        private var _camera:Camera;
        private var _video:Video;
        private var _bmpd:BitmapData;
        private var _rect:Sprite;
        //private var _color:uint = 0x000000;
        
        private var _red:Array = [];
        private var _green:Array = [];
        private var _blue:Array = [];
        
        
        public function CameraTest():void 
        {
            Wonderfl.capture_delay(10);
            _camera = Camera.getCamera();
            _camera.setMode(stage.stageWidth, stage.stageHeight, 15);
            //Security.showSettings(SecurityPanel.CAMERA);
            _video = new Video(stage.stageWidth, stage.stageHeight);
            _video.attachCamera(_camera);
            _video.filters = [new BlurFilter(10, 10, 1)];
            _bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            addChild(new Bitmap(_bmpd));
            
            _rect = new Sprite();
            addChild(_rect);
            
            colorArray();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            //stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function colorArray():void
        {
            var _level:int = 16;
            var _division:int = 512 / _level;
            for (var i:int = 0; i < 512; i++)
            {
                var value:Number = Math.floor(i / _division) * _division;
                _red[i] = value << 16;
                _green[i] = value << 8;
                _blue[i] = value;
            }
        }
        
        //private function onClick(e:MouseEvent):void 
        //{
            //_color = _bmpd.getPixel(mouseX, mouseY);
            //trace(_color);
        //}
        
        private function onEnterFrame(e:Event):void 
        {
            _bmpd.draw(_video, new Matrix( -1, 0, 0, 1, _bmpd.width, 0));
            _bmpd.paletteMap(_bmpd, _bmpd.rect, new Point(0,0), _red, _green, _blue);
            var rect:Rectangle = _bmpd.getColorBoundsRect(0xFFFFFF, 6299648, true);
            _rect.graphics.clear();
            _rect.graphics.beginFill(0xFFFFFF, 0.5);
            _rect.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            _rect.graphics.endFill();
            //_rect.blendMode = "screen";
        }
        
    }
    
}