/**
 * Copyright mikesoylu ( http://wonderfl.net/user/mikesoylu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hRlB
 */

// Conways Game of life by mikesoylu
// play/pause with tab
// click to add cell
// click+space to remove cell
package 
{
    import flash.display.*;
    import flash.utils.*;
    import flash.ui.*;
    import flash.events.*;
    import flash.geom.*;
    [SWF(width=230,height=230,frameRate=60,backgroundColor=0xffffff)]
    public class Main extends Sprite 
    {
        protected var dispBitmap:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff);
        protected var tempBitmap:BitmapData=new BitmapData(stage.stageWidth, stage.stageHeight, false,0xffffff);
        protected var rect:flash.geom.Rectangle= new flash.geom.Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        protected var point:flash.geom.Point = new flash.geom.Point();
        protected var i:int = 0;
        protected var j:int = 0;
        protected var k:int = 0;
        protected var simulate:Boolean=true;
        protected var mouseisDown:Boolean = false;
        protected var keyisDown:Boolean = false;
        protected var tmpBytes:ByteArray
        public function Main():void 
        {
            addChild(new Bitmap(dispBitmap));
            init();
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
            stage.addEventListener( MouseEvent.MOUSE_UP, mouseUp );
            stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDown );
            stage.addEventListener( KeyboardEvent.KEY_DOWN, keyDown );
            stage.addEventListener( KeyboardEvent.KEY_UP, keyUp );            
        }
        private function init():void
        {
            for (i = 0; i < 2000; i++) {
                dispBitmap.setPixel(Math.random() * (stage.stageWidth-2)+1, Math.random() * (stage.stageHeight-2)+1, 0x000000);
            }
        }
        public function keyDown( event:KeyboardEvent ):void 
        {
            switch(event.keyCode) {
                case Keyboard.SPACE: keyisDown = true; break;
            }
        }
        public function keyUp( event:KeyboardEvent ):void 
        {
            switch(event.keyCode) {
                case Keyboard.SPACE: keyisDown = false; break;
                case Keyboard.TAB: simulate = !simulate; break;
            }
        }
        public function mouseUp( event:MouseEvent ):void 
        {
            mouseisDown = false;
        }  
        public function mouseDown( event:MouseEvent ):void 
        {
            mouseisDown = true;
        }             
        public function enterFrame(event:Event):void 
        {
            if (mouseisDown) dispBitmap.setPixel(Math.round(mouseX), Math.round(mouseY), 0xffffff*int(keyisDown));
            if (simulate)
            {
            tempBitmap.fillRect(rect,0xffffff);
            for (i = 1; i < stage.stageWidth-1; i++) {
                for (j = 1; j < stage.stageHeight-1; j++) {
                    k = 0;    
                    if (dispBitmap.getPixel(i + 1, j) == 0x000000) k++;
                    if (dispBitmap.getPixel(i - 1, j) == 0x000000) k++;
                    if (dispBitmap.getPixel(i, j - 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i, j + 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i - 1, j + 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i - 1, j - 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i + 1, j + 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i + 1, j - 1) == 0x000000) k++;
                    if (dispBitmap.getPixel(i, j) == 0x000000) {
                        if (k == 3 || k == 2) tempBitmap.setPixel(i, j, 0x000000);
                    }
                    if (dispBitmap.getPixel(i, j) == 0xffffff) {
                        if (k == 3) tempBitmap.setPixel(i, j, 0x000000);
                    }
                }
            }
            tmpBytes = tempBitmap.getPixels(rect);
            tmpBytes.position = 0;
            dispBitmap.setPixels(rect,tmpBytes);
            }
        }
        
    }
    
}