/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hRIX
 */

// forked from axcel_work's ヒュースポン
package {
    import fl.motion.easing.Quartic;

    import jiglib.physics.RigidBody;
    import jiglib.plugin.papervision3d.Papervision3DPhysics;

    import com.bit101.components.PushButton;
    import com.flashdynamix.motion.Tweensy;
    import com.flashdynamix.motion.TweensyTimeline;

    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.*;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Vector3D;
    import flash.ui.Mouse;
    import flash.utils.Timer;

    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]

    /**
     * @author axcelwork
     */
    public class Index extends BasicView {
        private var _btnRetry:PushButton;    

        private var _physics:Papervision3DPhysics;

        private var _upper:int = 1000;

        private var _isSlow:Boolean = false;
        private var _isSet:Boolean = false;
        private var _isWeldone:Boolean = false;

        private var _ballPhy:RigidBody;
        private var _cameraTarget:DisplayObject3D;
        private var _stoperPhy:RigidBody;
        private var _hitPlate:RigidBody;
        private var _tube:Tube;

        // pv3d objs
        private var _light:PointLight3D = new PointLight3D();

        private var _cover:Sprite = new Sprite();
        private var _tween:TweensyTimeline;

        private var _recordX:Number;
        private var _recordZ:Number;

        
        // Timer
        private var _switchCamera2:Timer;
        private var _switchCamera3:Timer;
        private var _switchRate1:Timer;
        private var _switchRate2:Timer;

        /**
         * 
         */
        public function Index() {
            super(this.stage.stageWidth, this.stage.stageHeight, false, true, CameraType.FREE);
            
            // jiblib
            this._physics = new Papervision3DPhysics(this.scene, 9.8);
            
            this._light.y = 15000;
            this._light.z = -200;
            
            // Create Ground            
            var gMaterialList:MaterialsList = new MaterialsList();
            //gMaterialList.addMaterial(new WireframeMaterial(0xcccccc), "all");
            gMaterialList.addMaterial(new ColorMaterial(0xcccccc), "all");
            var ground:RigidBody = this._physics.createCube(gMaterialList, 1000, 1000, 300, 1, 1, 1);
            ground.movable = false;
            ground.restitution = 0.6;
            ground.friction = 0.98;
            
            // 筒
            this._tube = new Tube(this._physics, this._light);
            
            // ストッパーの作成
            var sMaterialList:MaterialsList = new MaterialsList();
            //sMaterialList.addMaterial(new WireframeMaterial(0xcccccc), "all");
            sMaterialList.addMaterial(new ColorMaterial(0xcccccc), "all");
            this._stoperPhy = this._physics.createCube(sMaterialList, 2000, 1000, 10);
            this._stoperPhy.movable = false;
            this._stoperPhy.y = this._upper;
            this._stoperPhy.z = -600;
            
            // Ball
            this._cameraTarget = new DisplayObject3D();
            //var ballMaterial:WireframeMaterial = new WireframeMaterial();
            var ballMaterial:FlatShadeMaterial = new FlatShadeMaterial(this._light, 0xffffff);
            ballMaterial.interactive = true;
            this._ballPhy = this._physics.createSphere(ballMaterial, 3, 15, 15);
            this._ballPhy.z = -150;
            this._ballPhy.y = this._upper + 40;
            this._ballPhy.friction = 0.98;
            
            this._hitPlate = this._physics.createCube(sMaterialList, 70, 70, 5);
            this._hitPlate.y = 150;
            this._hitPlate.friction = 0.98;
            this._hitPlate.movable = false;
            
            // init PV3D World
            this.startRendering();
            this.selectCamera1();
            
            this.stage.addEventListener(Event.ENTER_FRAME, enterFrame);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            
            this._switchCamera2 = new Timer(600, 1);
            this._switchCamera2.addEventListener(TimerEvent.TIMER_COMPLETE, switch2);
            
            this._switchCamera3 = new Timer(3000, 1);
            this._switchCamera3.addEventListener(TimerEvent.TIMER_COMPLETE, switch3_1);
            
            this._switchRate1 = new Timer(800, 1);
            this._switchRate1.addEventListener(TimerEvent.TIMER_COMPLETE, switchRate1);
            
            this._switchRate2 = new Timer(6000, 1);
            this._switchRate2.addEventListener(TimerEvent.TIMER_COMPLETE, switchRate2);
            
            this._cover.graphics.beginFill(0x0);
            this._cover.graphics.drawRect(0, 0, this.stage.stageWidth, this.stage.stageHeight);
            this._cover.graphics.endFill();
            this._cover.scaleX = 0;
            this.addChild(this._cover);
            
            this._btnRetry = new PushButton(this, 180, 220, "Retry", retry);
            this._btnRetry.visible = false;
        }

        protected function selectCamera4(event:Event = null):void {
            this._camera.x = 0;
            this._camera.y = 800;
            this._camera.z = -250;
            this._camera.rotationX = 50;
            this._camera.rotationY = 0;
            this._camera.target = this._cameraTarget;
            this._isSlow = false;
        }

        protected function selectCamera3(event:Event = null):void {
            this._camera.x = 100;
            this._camera.y = 800;
            this._camera.z = -100;
            this._camera.rotationX = 50;
            this._camera.rotationY = -50;
            this._camera.target = this._cameraTarget;
        }

        protected function selectCamera2(event:Event = null):void {
            this._camera.x = 0;
            this._camera.y = 650;
            this._camera.z = -1000;
            this._camera.rotationX = 0;
            this._camera.rotationY = 0;
            this._camera.target = this._cameraTarget;
            this._isSlow = false;
        }

        protected function selectCamera1(event:Event = null):void {
            this._camera.x = 0;
            this._camera.y = this._upper + 500;
            this._camera.z = -50;
            this._camera.rotationX = 90;
            this._camera.rotationY = 0;
            this._camera.target = null;
            this._isSlow = false;
        }

        
        
        private function mouseDown(e:MouseEvent):void {
            this.stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            this._isSet = true;
            this._switchCamera2.start();
            
            this._recordX = this._ballPhy.x;
            this._recordZ = this._ballPhy.z;
        }

        private function enterFrame(e:Event):void {
            if(!_isSet) {
                this._ballPhy.x = this.viewport.containerSprite.mouseX;
                this._ballPhy.y = this._upper + 40;
                this._ballPhy.z = -this.viewport.containerSprite.mouseY - 50;
            }
            
            this._cameraTarget.x = this._ballPhy.x;
            this._cameraTarget.y = this._ballPhy.y;
            this._cameraTarget.z = this._ballPhy.z;
            
            this._light.y = this._ballPhy.y + 1000;
            
            //trace(this._ballPhy.x, this._ballPhy.y, this._ballPhy.z);

            if(!this._isSlow) {
                this._physics.engine.integrate(0.45);
                this._ballPhy.friction = 0.98;
                this._tube.slow();
                
            } else {
                this._physics.engine.integrate(0.05);
                this._ballPhy.friction = 20;
                this._tube.normal();
            }
            
            //trace(this._ballPhy.x, this._ballPhy.y, this._ballPhy.z);

            
            if(this._ballPhy.hitTestObject3D(this._hitPlate)) {
                this._isWeldone = true;
            }
        }

        
        private function switch2(e:TimerEvent):void {
            this.selectCamera2();
            this._switchCamera3.start();
        }

        private function switch3_1(e:TimerEvent):void {
            this._cover.rotation = 0;
            this._cover.x = this._cover.y = 0;
            this._cover.alpha = 1;
            this._tween = Tweensy.to(this._cover, {scaleX: 1}, 0.8, Quartic.easeInOut);
            this._tween.onComplete = switch3_2;
        }

        private function switch3_2():void {
            this.selectCamera3();
            
            
            this._ballPhy.x = this._recordX;
            this._ballPhy.y = this._upper;
            this._ballPhy.z = this._recordZ;
            
            this._ballPhy.addWorldForce(new Vector3D(0, 10, 0), this._ballPhy.currentState.position);
            
            this._cover.rotation = 180;
            this._cover.x = this.stage.stageWidth;
            this._cover.y = this.stage.stageHeight;
            this._tween = Tweensy.to(this._cover, {scaleX: 0}, 0.8, Quartic.easeInOut);
            this._tween.onComplete = switch3_3;
        }

        private function switch3_3():void {
            this._switchRate1.start();
        }

        private function switchRate1(e:TimerEvent):void {
            trace("slow");
            this._isSlow = true;
            this._switchRate2.start();
        }

        private function switchRate2(e:TimerEvent):void {
            this._isSlow = false;
            
            this._cover.rotation = 0;
            this._cover.x = this._cover.y = 0;
            this._cover.alpha = 0.5;
            this._tween = Tweensy.to(this._cover, {scaleX: 1}, 0.8, Quartic.easeInOut);
            
            this._btnRetry.visible = true;
            
            if(this._isWeldone) {
            } else {
            }
        }

        protected function retry(event:Event = null):void {
            this._btnRetry.visible = false;
            
            this._isSet = false;
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            this.selectCamera1();
            
            this._cover.rotation = 180;
            this._cover.x = this.stage.stageWidth;
            this._cover.y = this.stage.stageHeight;
            Tweensy.to(this._cover, {scaleX: 0}, 0.8, Quartic.easeInOut);
        }
    }
}

import jiglib.physics.RigidBody;
import jiglib.plugin.papervision3d.Papervision3DPhysics;

import org.papervision3d.lights.PointLight3D;
import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
import org.papervision3d.materials.utils.MaterialsList;

class Tube {
    private var _rdius:int = 74;

    private var tubeFront:RigidBody;
    private var tubeBack:RigidBody;
    private var tubeLeft:RigidBody;
    private var tubeRight:RigidBody;
    private var plateFront:RigidBody;
    private var plateBack:RigidBody;
    private var plateLeft:RigidBody;
    private var plateRight:RigidBody;

    
    
    public function Tube(physics:Papervision3DPhysics, light:PointLight3D) {
        
        var tubeMaterialList:MaterialsList = new MaterialsList();
        //tubeMaterialList.addMaterial(new WireframeMaterial(0x444444), "all");
        tubeMaterialList.addMaterial(new FlatShadeMaterial(light, 0x444444), "all");
        
        var plateMaterialList:MaterialsList = new MaterialsList();
        //plateMaterialList.addMaterial(new WireframeMaterial(0x444444), "all");
        plateMaterialList.addMaterial(new FlatShadeMaterial(light, 0xeeeeee), "all");
        
        tubeFront = physics.createCube(tubeMaterialList, _rdius, 5, 500);
        tubeFront.movable = false;
        tubeFront.x = 0;
        tubeFront.y = 400;
        tubeFront.z = _rdius / 2;
        
        tubeBack = physics.createCube(tubeMaterialList, _rdius, 5, 500);
        tubeBack.movable = false;
        tubeBack.x = 0;
        tubeBack.y = 400;
        tubeBack.z = -_rdius / 2;
        
        tubeLeft = physics.createCube(tubeMaterialList, 5, _rdius + 5, 500);
        tubeLeft.movable = false;
        tubeLeft.x = -39;
        tubeLeft.y = 400;
        tubeLeft.z = 0;
        
        tubeRight = physics.createCube(tubeMaterialList, 5, _rdius + 5, 500);
        tubeRight.movable = false;
        tubeRight.x = 39;
        tubeRight.y = 400;
        tubeRight.z = 0;
        
        plateFront = physics.createCube(plateMaterialList, _rdius + 9, 5, 10);
        plateFront.movable = false;
        plateFront.x = 0;
        plateFront.y = 643;
        plateFront.z = 42;
        
        plateBack = physics.createCube(plateMaterialList, _rdius + 9, 5, 10);
        plateBack.movable = false;
        plateBack.x = 0;
        plateBack.y = 643;
        plateBack.z = -42;
        
        plateLeft = physics.createCube(plateMaterialList, 5, _rdius + 15, 10);
        plateLeft.movable = false;
        plateLeft.x = -44;
        plateLeft.y = 643;
        plateLeft.z = 0;
        
        plateRight = physics.createCube(plateMaterialList, 5, _rdius + 15, 10);
        plateRight.movable = false;
        plateRight.x = 44;
        plateRight.y = 643;
        plateRight.z = 0;
    }

    public function slow():void {
        tubeFront.restitution = tubeBack.restitution = tubeLeft.restitution = tubeRight.restitution = plateFront.restitution = plateBack.restitution = plateLeft.restitution = plateRight.restitution = 12;
        tubeFront.friction = tubeBack.friction = tubeLeft.friction = tubeRight.friction = plateFront.friction = plateBack.friction = plateLeft.friction = plateRight.friction = 20;
    }

    public function normal():void {
        tubeFront.restitution = tubeBack.restitution = tubeLeft.restitution = tubeRight.restitution = plateFront.restitution = plateBack.restitution = plateLeft.restitution = plateRight.restitution = 0.6;
        tubeFront.friction = tubeBack.friction = tubeLeft.friction = tubeRight.friction = plateFront.friction = plateBack.friction = plateLeft.friction = plateRight.friction = 0.98;
    }
}


