/**
 * Copyright hidebo ( http://wonderfl.net/user/hidebo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hQTd
 */

// forked from hidebo's #1 click game ver 0.01
package {                                                    // お約束
    import flash.display.*;                                    // 使うなら書け
    import flash.text.*;
    import flash.events.*;
    import flash.utils.getTimer;
    
    [SWF(width=240, height=240, backgroundColor=0xFFFFFF)]    // 意味不明
    public class Main extends Sprite {                        // イマイチ不明
        private const MAT_R:int = 10;                    // 的の半径
        private const TRY_COUNT:int = 5;                    // 何回するか

        private const WEEK:Array = ["日", "月", "火", "水", "木", "金", "土"];

        private var monitor:TextField;                        // デバッグ用のモニター表示部
        private var gm:TextField;                        // ゲームメッセージ表示部
        private var sf:TextField;                        // スコア表示部
        private var canvas:Sprite;                       // 的表示部

        private var irqcounter:uint = 0;                       // IRQC
        private var trycount:int = 0;                       // クリックした回数
        private var score:int = 0;                       // スコア合計
        private var oldtime:int = 0;
        private var clicktime:int = 0;

        /****************************************************************/
        //        始まりはいつもここから
        /****************************************************************/
        public function Main() {
            gm = new TextField();
            gm.defaultTextFormat = new TextFormat("_typeWriter", 30, 0x0, true);
            gm.selectable = false;                      //選択不可
            gm.autoSize = "left";
            gm.text = "START";                                // ＳＴＡＲＴ表示したい
            gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
            gm.y = (stage.stageHeight - gm.height) / 2;
            addChild(gm);
 
            monitor = new TextField();                        // モニターだすのだ
            monitor.defaultTextFormat = new TextFormat("_typeWriter", 8, 0x0, true);
            monitor.width  = stage.stageWidth;          // 幅は画面いっぱい
            monitor.height = 12;                        // 高さ            
            monitor.background = true;                        // 背景色つけるよ
            monitor.backgroundColor = 0xF0F0F0;            
            addChild(monitor);
  
            stage.frameRate = 60;                                // 60FPS(１秒６０コマ)だよ
            addEventListener(Event.ENTER_FRAME, onEnterFrame);    // １フレームごとに飛んでけ
            stage.addEventListener(MouseEvent.CLICK, init);    //クリックしたらはじまるよ
        }
        /****************************************************************/
        //    １フレーム毎に飛んでくるよ
        /****************************************************************/
        private function onEnterFrame(evt:Event):void {
            var date:Date = new Date();
            monitor.text = "";
            monitor.appendText(date.fullYear+"年"+(date.month+1)+"月"+date.date+"日"+"("+WEEK[date.day]+")"+date.toLocaleTimeString()); 
            monitor.appendText(" IRQC="+(++irqcounter).toString());                // IRQC書くよ
        }
        /****************************************************************/
        //    初期化しちゃうよ
        /****************************************************************/
        private function init(event:Event):void {
            stage.removeEventListener(MouseEvent.CLICK, init);    //　START の CLICK はもう忘れた
            gm.visible = false;                                    // メッセージはさしあたり消えといて

            score = 0                                       // スコアは０に
            trycount = 0                                    // 回数も０
            oldtime=getTimer();                            // 開始時間を覚えとこう
          
            sf = new TextField();                        //スコア書くよ
            sf.defaultTextFormat = new TextFormat("_ゴシック", 16, 0x0, true);
            sf.autoSize = "left";
            sf.selectable = false;                      //選択不可
            addChild(sf);                                //表示しといてね
            sf.text = "SCORE="+score.toString();                // スコア書くよ
            sf.y = stage.stageHeight - sf.height;                    // スコアの位置は下だよ

            canvas = new Sprite();                        //的書くよ
            canvas.graphics.beginFill(0xFF0000);            // 赤色で塗りつぶすよ
            canvas.graphics.drawCircle(0, 0, MAT_R);           // (0,0)ベースで書くよ
            canvas.graphics.endFill();                         // さあ書け
            matoRandom();
            addChild(canvas);                                // 表示しといてね
            // event 
            canvas.addEventListener(MouseEvent.CLICK, onMouseClick);    // 的をクリックしたら飛んでね
        }
        /****************************************************************/
        //    的をクリックしたらやる事あるよ
        /****************************************************************/
        private function onMouseClick(evt:MouseEvent):void {
            var nowscore:int;
            clicktime=getTimer()-oldtime;                                // クリック時間計算しちゃえ
            oldtime+=clicktime;
            trycount++; 

            nowscore = (10000-clicktime)/100;                            // 時間でスコア決めちゃった
            if (nowscore < 0) nowscore = 0;                                // あんまり遅いと０点に
            score += nowscore;                                            // スコア合計アップ
  
            if (trycount >= TRY_COUNT) end()                            // 終わっちゃった？
            else {
                sf.text = trycount+"回 SCORE="+(score).toString()+"点, 今回"+nowscore+"点";               // スコア書くよ
                sf.y = stage.stageHeight - sf.height;                    // スコアの位置は下だよ
    
                matoRandom();                                            // 的はランダムがお好き
            }
        }
        /****************************************************************/
        //    的の場所をランダムで決めちゃうよ
        /****************************************************************/
        private function matoRandom():void {
            canvas.x = Math.random()*(stage.stageWidth-MAT_R*2)+MAT_R;    // ランダムで次の位置決めるよ
            canvas.y = Math.random()*(stage.stageHeight-MAT_R*2)+MAT_R;
        }
        /****************************************************************/
        //    終わったぁ
        /****************************************************************/
        private function end():void
        {
            canvas.visible = false;                                    // 的はさしあたり消えといて
            canvas.removeEventListener(MouseEvent.CLICK, onMouseClick); // 処理を止める
 
            gm.visible = true;                                    // メッセージは出したいね
            gm.text = "FINISH";                                // FINISH表示したい
            gm.x = (stage.stageWidth  - gm.width ) / 2;        // 真ん中に
            gm.y = (stage.stageHeight - gm.height) / 2;

            sf.text = "SCORE = "+(score).toString()+"/"+TRY_COUNT*100+"点";               // スコア書くよ
            sf.x = (stage.stageWidth - sf.width)/2;                    // スコアの位置は下だよ
            sf.y = (stage.stageHeight*3/4);                    // スコアの位置は下だよ
        }
     }
}