/**
 * Copyright Ludd ( http://wonderfl.net/user/Ludd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hPUu
 */

// forked from ProjectNya's 雪 (フルスクリーン) [Papervision3D] ぐるぐるバージョン
////////////////////////////////////////////////////////////////////////////////
// 雪 (フルスクリーン) [Papervision3D] ぐるぐるバージョン
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var wonderflcolor:WonderflColor;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var particles1:ParticleField;
        private var particles2:ParticleField;
        private var angle:Number = 90;
        private static var radius:uint = 1000;
        private var panel:Sprite;
        private var fullscreenBtn:Btn;
        private var normalBtn:Btn;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            //Wonderfl.capture_delay(8);
            init();
        }

        private function init():void {
            wonderflcolor = new WonderflColor(465, 465);
            addChild(wonderflcolor);
            //
            scene = new Scene3D();
            camera =new Camera3D();
            camera.z = -1000;
            camera.focus = 500;
            camera.zoom = 1;
            camera.target = DisplayObject3D.ZERO;
            viewport = new Viewport3D(0, 0, true, false);
            addChild(viewport);
            renderer = new BasicRenderEngine();
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
            var pm:ParticleMaterial = new ParticleMaterial(0xFFFFFF, 1, 1, 1);
            particles1 = new ParticleField(pm, 800, 8, 3000, 3000, 3000);
            particles2 = new ParticleField(pm, 800, 8, 3000, 3000, 3000);
            scene.addChild(particles1);
            scene.addChild(particles2);
            particles1.y = 0;
            particles2.y = 3000;
            //
            panel = new Sprite();
            addChild(panel);
            panel.x = 232;
            panel.y = 445;
            fullscreenBtn = new Btn();
            panel.addChild(fullscreenBtn);
            fullscreenBtn.x = 0;
            fullscreenBtn.init({label: "full screen", width: 100});
            fullscreenBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn = new Btn();
            panel.addChild(normalBtn);
            normalBtn.x = 0;
            normalBtn.init({label: "normal", width: 100});
            normalBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn.visible = false;
            stage.addEventListener(Event.RESIZE, update, false, 0, true);
        }
        private function render(evt:Event):void {
            particles1.y -= 10;
            particles2.y -= 10;
            if (particles1.y < - 3000) particles1.y = 3000;
            if (particles2.y < - 3000) particles2.y = 3000;
            angle += 3;
            camera.x = radius*Math.sin(angle*Math.PI/180);
            camera.z = radius*Math.cos(angle*Math.PI/180);
            renderer.renderScene(scene, camera, viewport);
        }
        private function update(evt:Event = null):void {
            var sw:uint = stage.stageWidth;
            var sh:uint = stage.stageHeight;
            panel.x = sw/2;
            panel.y = sh - 20;
            wonderflcolor.width = sw;
            wonderflcolor.height = sh;
            if (stage.displayState == StageDisplayState.FULL_SCREEN) {
                fullscreenBtn.visible = false;
                normalBtn.visible = true;
            } else {
                fullscreenBtn.visible = true;
                normalBtn.visible = false;
            }
        }
        private function click(evt:Event):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
        }
        
    }

}


//////////////////////////////////////////////////
// WonderflColorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class WonderflColor extends Sprite {
    private var color1:uint = 0x00AAE4;
    private var color2:uint = 0x0069A0;

    public function WonderflColor(w:uint, h:uint) {
        draw(w, h);
    }

    private function draw(w:uint, h:uint):void {
        var colors:Array = [color1, color2];
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*1.5, h*1.5, 0, -w*0.25, -h*0.25);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, w, h);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
