/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hP8J
 */

// forked from tkinjo's PV3D でマルチビュー（問題点あり）
package  
{
	/**
	 * PV3D でマルチビュー（問題ありのまま）
	 */
	
	import flash.display.Sprite;
	import flash.events.Event;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.proto.CameraObject3D;
	import org.papervision3d.core.proto.SceneObject3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.view.Viewport3D;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		/**
		 * 
		 */
		private var scene:SceneObject3D;
		private var renderer:BasicRenderEngine;
		
		private var viewports:Vector.<Viewport3D>;
		private var cameras:Vector.<CameraObject3D>;
		
		private var cube:Cube;
		
		/**
		 * 
		 */
		public function Main() 
		{
			scene = new SceneObject3D();
			renderer = new BasicRenderEngine();
			
			viewports = new Vector.<Viewport3D>();
			cameras = new Vector.<CameraObject3D>();
			for ( var i:uint = 0; i < 4; i++ ) {
				
				var viewport:Viewport3D = new Viewport3D( stage.stageWidth / 2, stage.stageHeight/ 2 );
				viewport.x = stage.stageWidth / 2 * ( i % 2 );
				viewport.y = stage.stageHeight / 2 * uint( i / 2 );
				
				var camera:CameraObject3D = new Camera3D();
				camera.target = DisplayObject3D.ZERO;
				camera.z = 0;
				camera.zoom = 115;
				
				viewports.push( viewport );
				cameras.push( camera );
				
				addChild( viewport );
			}
			cameras[ 0 ].y = 1000;
			cameras[ 0 ].z = 1;	// 0 だと表示されない。なぜ？
			cameras[ 1 ].x = 1000;
			cameras[ 1 ].y = 1000;
			cameras[ 2 ].z = 1000;
			cameras[ 3 ].x = 1000;
			
			/**
			 * キューブの作成
			 * 
			 * キューブのコンストラクタ
			 * http://papervision3d.googlecode.com/svn/trunk/as3/trunk/docs/org/papervision3d/objects/primitives/Cube.html#Cube()
			 */
			var cubeMaterialParams:Array = [ 
					{ name:"front", color:0xff0000 }, 
					{ name:"back", color:0xffff00 }, 
					{ name:"right", color:0x00ff00 }, 
					{ name:"left", color:0x00ffff }, 
					{ name:"top", color:0x0000ff },
					{ name:"bottom", color:0xff00ff } 
				];
			var cubeMaterialsList:MaterialsList = new MaterialsList();
			for ( i = 0; i < 6; i++ ) {
				//var colorMaterial:ColorMaterial = new ColorMaterial( cubeMaterialParams[ i ].color );
				var colorMaterial:ColorMaterial = new ColorMaterial( cubeMaterialParams[ i ].color, 0.5 );
				colorMaterial.doubleSided = true;	// true にすると辺のふちが欠ける
				cubeMaterialsList.addMaterial( colorMaterial, cubeMaterialParams[ i ].name );
			}
			cube = new Cube( cubeMaterialsList, 100, 100, 100 );
			scene.addChild( cube );
			
			/**
			 * 
			 */
			addEventListener(Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			cube.rotationY++;
			
			for ( var i:uint = 0; i < 4; i++ ) {
				
				renderer.renderScene( scene, cameras[ i ], viewports[ i ] );
			}
		}
	}
}