/**
 * Copyright shaggy ( http://wonderfl.net/user/shaggy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hOmf
 */

// forked from mousepancyo's Half Tone Screen Cam
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.net.*;
    import flash.utils.ByteArray;
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.*;
    import flash.filters.BlurFilter;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite{
        private const FILTER_URL:String = "http://www.digifie.jp/files/filters/halftone.pbj";
        private var _loader:URLLoader;
        private var _shader:Shader;
        private var _filter:ShaderFilter;
        private var _container:Sprite;
        private var _srcBmd:BitmapData;
        private var _bm:Bitmap;
        private var _video:CameraCapture;
        private var _saveBmd:BitmapData;
        private var _ctf:ColorTransform = new ColorTransform;
        private var _fr:FileReference = new FileReference();
        private var _chengeBtn:PushButton;
        private var _blendBtn:PushButton;
        private var _saveBtn:PushButton;
        private var _slider:HSlider;

        public function Main() {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0xF0F0F0)));
            _ctf = new ColorTransform(-1, -1, -1, 1, 255, 255, 255, 0); 
            _chengeBtn = new PushButton(this, 72, 350, "Normal", viewChenge);
            _blendBtn = new PushButton(this, 175, 350, "Color Drawing", blendVideo);
            _saveBtn = new PushButton(this, 293, 350, "Save Image", save);
            _slider = new HSlider(this, 72, 85, changeVal);
            var label:Label = new Label(this, 70, 65, "Gamma")
            //
            _srcBmd = new BitmapData(320, 240, false, 0);
            _saveBmd = _srcBmd.clone();
            _bm = new Bitmap(_srcBmd);
            _container = new Sprite();
            _container.x = 72;
            _container.y = 100;
            //
            filterLoad();
        }
        
        // Load Filter
        private function filterLoad():void{
            _loader = new URLLoader;
            _loader.addEventListener(Event.COMPLETE, onLoaded);
            _loader.dataFormat = URLLoaderDataFormat.BINARY;
            _loader.load(new URLRequest(FILTER_URL));
        }
        private function onLoaded(e:Event):void{
            _loader.removeEventListener(Event.COMPLETE, onLoaded);
            // CreateFilter
            _shader = new Shader(_loader.data);
            _shader.data.dot_spacing.value = [6];
            _shader.data.gamma.value = [2];
            _shader.data.max_dot_size.value = [4];
            _filter = new ShaderFilter(_shader);
            // Video
            _video = new CameraCapture(320, 240, 30);
            _video.visible = false;
            addEventListener(Event.ENTER_FRAME, update);
            _container.addChild(_video);
            _container.addChild(_bm);
            
            _slider.value = _shader.data.gamma.value * 20;
            addChild(_container);
            //
               blendVideo();
        }
        
        // View Update
        private function update(e:Event):void{
            _srcBmd.draw(_video)
            // addedFilter
            _srcBmd.applyFilter(_srcBmd, _srcBmd.rect, new Point(), _filter);
            _srcBmd.applyFilter(_srcBmd, _srcBmd.rect, new Point(), new BlurFilter(2,2));
        }
        
        private function changeVal(e:Event):void{
            var n:Number = e.currentTarget.value * .05;
            _shader.data.gamma.value = [n];
        }
        
        // MouseEvent
        private function viewChenge(e:MouseEvent = null):void{
            if(_video.visible && !_bm.visible){
                _video.visible = false;
                _bm.visible = true;
                _chengeBtn.label = "Normal"
            }else if(_bm.visible && !_video.visible){
                _video.visible = true;
                _bm.visible = false;
                _chengeBtn.label = "Line Drawing"
            }else{
                if(_chengeBtn.label == "Normal"){
                    _video.visible = true;
                    _bm.visible = false;
                    _chengeBtn.label = "Line Drawing"
                }else if(_chengeBtn.label == "Line Drawing"){
                    _video.visible = false;
                    _bm.visible = true;
                    _chengeBtn.label = "Normal"
                }
                _bm.blendMode = "normal";
                _blendBtn.mouseEnabled = true;
                _blendBtn.alpha = 1;
            }
        }
        private function blendVideo(e:MouseEvent = null):void{
            _video.visible = _bm.visible = true;
            _bm.blendMode = "screen";
            _blendBtn.mouseEnabled = false;
            _blendBtn.alpha = .3;
            if(_chengeBtn.label == "Normal"){
                _chengeBtn.label = "Line Drawing"
            }else if(_chengeBtn.label == "Line Drawing"){
                _chengeBtn.label = "Normal"
            }
        }
        private function save(e:MouseEvent):void{
            removeEventListener(Event.ENTER_FRAME, update);
            _saveBmd.draw(_container);
            fileSave(_saveBmd);
        }
        
        // ImageFile Save
        private function fileSave($bmd:BitmapData):void {
            var png:ByteArray = PNGEncoder.encode($bmd);
            _fr.addEventListener(Event.COMPLETE, complete);
            _fr.addEventListener(Event.CANCEL, cancel);
            _fr.addEventListener(IOErrorEvent.IO_ERROR, ioError);
            var date:Date = new Date;
            _fr.save(png, "image_" + date.getTime() + ".png");
            //
            function complete(e:Event):void{
                removedEventListener();
                addEventListener(Event.ENTER_FRAME, update);
            }
            function cancel(e:Event):void{
                removedEventListener();
                addEventListener(Event.ENTER_FRAME, update);
            }
            function ioError(e:IOErrorEvent):void{
                removedEventListener();
                addEventListener(Event.ENTER_FRAME, update);
            }
            //
            function removedEventListener():void{
                _fr.removeEventListener(Event.COMPLETE, complete);
                _fr.removeEventListener(Event.CANCEL, cancel);
                _fr.removeEventListener(IOErrorEvent.IO_ERROR, ioError);
            }
        }

    }
    
}


// Camera
import flash.media.Video;
import flash.events.Event;
import flash.media.Camera;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:int;
    private var _camH:int;
    private var _fps:Number;

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30) {
        this.width = camW;
        this.height = camH;
        _camW = camW;
        _camH = camH;
        _fps = fps;
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
    }
}