/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hOXh
 */

// forked from cpu_t's Soundを動的に生成, computeSpectrum使って出力
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    
    [SWF(frameRate="30", width="512", height="300")]
    public class BitmapToSound extends Sprite {
        private var _playingSound:Sound;
        private var _soundChannel:SoundChannel;
        
        private var _isPlay:Boolean = false;
        
        private var _soundWaveShape:Shape;
        
        public function BitmapToSound() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN,
            function(e:MouseEvent):void
            {
                if (_isPlay) _soundChannel.stop();
                else _soundChannel = _playingSound.play();
                _isPlay = !_isPlay;
            });
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            _playingSound = new Sound();
            _playingSound.addEventListener(SampleDataEvent.SAMPLE_DATA, soundWaveGenerator);
            _soundChannel = _playingSound.play();
            _isPlay = true;
            
            _soundWaveShape = new Shape();
            addChild(_soundWaveShape);
        }
        
        private function enterFrameHandler(e:Event):void
        {
            if (_isPlay) drawSoundWave();
        }
        
        private function soundWaveGenerator(event:SampleDataEvent):void
        {
            var v:Number;
            for (var c:int = 0; c < 8192; c++) {
                v = Math.sin((Number(c + event.position) / Math.PI / 2));
                v = v * 0.25;
                event.data.writeFloat(v); // 左チャンネルに書き込み
                event.data.writeFloat(v); // 右チャンネルに書き込み
            }
        }
        
        private function drawSoundWave():void
        {
            var i:int, n:Number;
            var bytes:ByteArray = new ByteArray();
            const PLOT_HEIGHT:int = 140;
            const CHANNEL_LENGTH:int = 256;
            
            SoundMixer.computeSpectrum(bytes, false, 0);
            
            _soundWaveShape.graphics.clear();
            _soundWaveShape.graphics.beginFill(0x404040);
            _soundWaveShape.graphics.drawRect(0, 0, 512, 300);
            _soundWaveShape.graphics.endFill();
            
            // 左チャンネル出力
            _soundWaveShape.graphics.lineStyle(1, 0x00FF00);
            _soundWaveShape.graphics.beginFill(0x00FF00, 0.5);
            _soundWaveShape.graphics.moveTo(0, PLOT_HEIGHT);
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                n = bytes.readFloat();
                n = n * PLOT_HEIGHT;
                _soundWaveShape.graphics.lineTo(i * 2, PLOT_HEIGHT - n);
            }
            _soundWaveShape.graphics.lineTo(CHANNEL_LENGTH * 2, PLOT_HEIGHT);
            _soundWaveShape.graphics.endFill();
            
            // 右チャンネル出力
            _soundWaveShape.graphics.lineStyle(1, 0x00FFFF);
            _soundWaveShape.graphics.beginFill(0x00FFFF, 0.5);
            _soundWaveShape.graphics.moveTo(0, PLOT_HEIGHT * 2);
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                n = bytes.readFloat();
                n = n * PLOT_HEIGHT;
                _soundWaveShape.graphics.lineTo(i * 2, PLOT_HEIGHT * 2 - n);
            }
            _soundWaveShape.graphics.lineTo(CHANNEL_LENGTH * 2, PLOT_HEIGHT * 2);
            _soundWaveShape.graphics.endFill();
        }
    }
}
