/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hNg4
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    [SWF(backgroundColor=0x000000,frameRate=60)]
    public class FlashTest extends Sprite {
        private var _canvas:BitmapData;
        private var _farballs:Vector.<FarBall> = new Vector.<FarBall>();
        public function FlashTest() {
            addChild( new RectSprite(0xff<<24) );
            
            _canvas = new BitmapData( 465, 465, true, 0x00 );
            
            var bm:Bitmap;
            addChild( bm = new Bitmap(_canvas) );
            bm.smoothing = true;
            //bm.filters = [ new BlurFilter(2,2) ];
            
            addEventListener( Event.ENTER_FRAME, enterframe ); 
            stage.addEventListener( MouseEvent.CLICK, addFarBall ); 
        }
        private function addFarBall( e:MouseEvent ):void {
            var f:FarBall = new FarBall(Math.random()*60+560, Math.random()*30+30);
            f.x = e.stageX;
            f.y = e.stageY;
            _farballs.push( f );
        }
        private function enterframe(e:Event):void{
            _canvas.lock();
            for each( var f:FarBall in _farballs ) {
                 f.draw( _canvas );
            }
            _canvas.unlock();
        }
    }
}
import flash.display.*;

class FarBall {
    public var x:Number = 0;
    public var y:Number = 0;
    private var _particles:Vector.<Particle> = new Vector.<Particle>();
    public function FarBall( count:int = 300, life:int = 60 ){
        const RADIAN :Number = 2*Math.PI;
        for( var i:int=0; i<count; ++i ) {
            var angle:Number= Math.random()*RADIAN;
            var p:Particle = new Particle();
            p.x  = 0;
            p.y  = 0;
            p.vx = Math.cos(angle);
            p.vy = Math.sin(angle);
            p.life = Math.random()* 30 + life;
            _particles.push(p);
        }
    }
    public function draw( canvas:BitmapData ) :void {
            for each( var p:Particle in _particles ) {
                if( p.life > 0 ) {
                     p.x += p.vx;
                     p.y += p.vy;
                     var a:uint = (p.life/90)*256;
                     canvas.setPixel32( p.x+Math.cos(p.life/6)+x, p.y+Math.sin(p.life/6)+y, 0xFFFFFF|a<<24 );
                     p.life--;
                }
            }    
    }
}
class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var life:Number;
    public var spiral:Number;
}

class RectSprite extends Sprite {
    public function RectSprite( color:uint ) {
        super();
        var c:uint = color & 0xFFFFFF;
        var a:uint = color & (0xFF<<24)
        graphics.beginFill( c, a/256 );
        graphics.drawRect(0,0,465,465);
        graphics.endFill();
    }
}