/**
 * Copyright poepoemix ( http://wonderfl.net/user/poepoemix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hNYO
 */

// forked from poepoemix's HttpTakStreamingPlayer
package
{
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.display.LoaderInfo;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.Sprite;
    public class HttpTakStreamingPlayer extends Sprite
    {
        private var compHelper:*;
        private var takHelper:*;
        /**
         * コンストラクタ
         */
        public function HttpTakStreamingPlayer()
        {
            if(stage) {
                pre_init();
            }
            else {
                addEventListener(Event.ADDED_TO_STAGE, pre_init);
            }
        }
        /**
         * 事前処理
         */
        private function pre_init():void {
            removeEventListener(Event.ADDED_TO_STAGE, pre_init);
            if(!stage) {
                return;
            }
            var comp:* = new MyLoader("http://swf.wonderfl.net/swf/usercode/3/37/37ea/37ea71571d353e8be4841dd5730420e9bb4cfb85.swf");
            var tak:*  = new MyLoader("http://swf.wonderfl.net/swf/usercode/0/0d/0d8f/0d8f57008c5cac11340dd099f3943be9e748fe15.swf");
            MyLoader.loadAll(function():void{
                // 全swfを読み込んだら処理開始
                var HelperClass:Class = comp.getClass("ComponentHelper");
                // comp動作の構築
                compHelper = new HelperClass();
                compHelper.gray();
                // ロガーの準備
                var logger:* = compHelper.logger();
                logger.setup(stage);
                Logger.setLogger(logger);
                // takクラスの準備
                var TakClass:Class = tak.getClass("TakHelper");
                takHelper = new TakClass();
                takHelper.setLogger(logger);
                // 準備が完了したら、全体の初期化を実行する。
                init();
            });
        }
        /**
         * 初期化
         */
        private function init():void {
            // uiの準備をしておく。
            var panel:* = compHelper.base({parent:this, left:10, top:10, width:stage.stageWidth - 20, height:stage.stageHeight - 20, log:true});
            // video
            var videoPanel:* = compHelper.panel({parent:panel, left:10, top:10, width:320, height:240});
            var stream:* = takHelper.createStream();
            var video:* = takHelper.createVideo();
            stream.bufferTime = 0;
            video.attachFlvStream(stream);
            video.x = 0; video.y = 0;
            videoPanel.addChild(video);
            // label
            compHelper.label({parent:panel, left:10, top:260, text:"ftlアドレス"});
            // urlInput
            var ftlUrl:* = compHelper.inputText({parent:panel, left: 80, top:260, text:"http://49.212.39.17/stest/tak/test/index.ftl", width:(panel.width - 150)});
            // playButton
            compHelper.button({parent:panel, left:(panel.width - 60), top:259, width:50, text:"play", func:function():void{
                stream.play("http://49.212.39.17/stest/tak/test/index.ftl");
                stream.soundTransform = new SoundTransform(volumeSlider.value / 100);
            }});
            // volume
            var volume:* = compHelper.label({parent:panel, left:10, top:280, text:"volume:100"});
            // volumeSlider
            var volumeSlider:* = compHelper.hSlider({parent:panel, left:80, top: 283, func:function():void {
                volume.text = "volume:" + int(volumeSlider.value);
                stream.soundTransform = new SoundTransform(volumeSlider.value / 100);
            }});
            volumeSlider.value = 100;
            // skin
            compHelper.label({parent:panel, left:10, top:300, text:"スキン"});
            // skin selector
            var skinSelector:* = compHelper.comboBox({parent:panel, left: 80, top: 299, "default":"Gray", list:["Red", "Blue", "Orange", "Green", "Aqua", "Gray"]});
            skinSelector.addEventListener(Event.SELECT, function(event:Event):void {
                switch(skinSelector.selectedItem) {
                    case "Red":    compHelper.red();    break;
                    case "Blue":   compHelper.blue();   break;
                    case "Orange": compHelper.orange(); break;
                    case "Green":  compHelper.green();  break;
                    case "Aqua":   compHelper.aqua();   break;
                    case "Gray":
                    default:       compHelper.gray();   break;
                }
                compHelper.refresh(stage);
            });
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void {
                panel.addChild(l);
            });
            l.load(new URLRequest("http://swf.wonderfl.net/swf/usercode/7/7f/7f47/7f473f59da9b540cea2fe4a4e125863bf35bc1fc.swf"));
        }
    }
}
import flash.utils.ByteArray;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.URLLoaderDataFormat;
import flash.net.URLLoader;

import flash.display.LoaderInfo;
import flash.system.ApplicationDomain;
import flash.net.URLRequest;
import flash.events.Event;
import flash.display.Loader;

/**
 * ロガー
 */
class Logger {
    // compHelperのロガーを登録しておく。
    public static var logger:* = null;
    public static function setLogger(logger:*):void {
        Logger.logger = logger;
    }
    public static function fatal(obj:*):void {if(logger != null)logger.fatal(obj);}
    public static function error(obj:*):void {if(logger != null)logger.error(obj);}
    public static function warn(obj:*):void  {if(logger != null)logger.warn(obj);}
    public static function info(obj:*):void  {if(logger != null)logger.info(obj);}
    public static function debug(obj:*):void {if(logger != null)logger.debug(obj);}
}

/**
 * ロード動作の補助
 */
class MyLoader {
    // 全ローダーの保持
    private static var loaderSet:Array = [];
    // 残りの読み込むターゲット数
    private static var targetNum:int = 0;
    // 各ローダー用のドメイン空間
    private var domain:ApplicationDomain = null;
    // 各ローダー用のターゲットURL
    private var url:String = null;
    /**
     * コンストラクタ
     */
    public function MyLoader(url:String) {
        this.url = url;
        loaderSet.push(this);
    }
    /**
     * クラス参照
     */
    public function getClass(name:String):Class {
        if(domain == null) {
            throw new Error("loading is not complete yet...");
        }
        return domain.getDefinition(name) as Class;
    }
    public function hasClass(name:String):String {
        if(domain == null) {
            throw new Error("loading is not complete yet...");
        }
        return "" + domain.hasDefinition(name);
    }

    /**
     * 全ローダー読み込み完了時にfuncを実行
     */
    public static function loadAll(func:Function):void {
        targetNum = loaderSet.length;
        var token:String = "?" + (new Date()).getTime();
        for each(var myLoader:MyLoader in loaderSet) {
            load(myLoader, token, func);
        }
    }
    /**
     * 個別のローダーの読み込み動作
     * securityエラー等は考慮せず
     * /
    private static function load(myLoader:MyLoader, token:String, func:Function):void {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(event:Event):void {
            myLoader.domain = LoaderInfo(event.target).applicationDomain;
            targetNum --;
            if(targetNum == 0) {
                func();
            }
        });
        loader.load(new URLRequest(myLoader.url + token));
    }*/

    private static function load(myLoader:MyLoader, token:String, func:Function):void {
        var loader:URLLoader = new URLLoader;
        loader.dataFormat = URLLoaderDataFormat.BINARY;
        loader.addEventListener(Event.COMPLETE, function(event:Event):void {
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(event:Event):void {
                myLoader.domain = LoaderInfo(event.target).applicationDomain;
                targetNum --;
                if(targetNum == 0) {
                    func();
                }
            });
            l.loadBytes(loader.data as ByteArray);
        });
        loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, function(event:SecurityError):void{
        });
        loader.addEventListener(IOErrorEvent.IO_ERROR, function(event:IOErrorEvent):void {
            
        });
        var request:URLRequest = new URLRequest(myLoader.url + token);
        try {
            loader.load(request);
        }
        catch(e:Error) {
        }
    }
}
