/**
 * Copyright gen_suke ( http://wonderfl.net/user/gen_suke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hMWi
 */

///////////////////////////////////
//  フラクタルにょきにょきツリー    // 
//////////////////////////////////
package {
	import flash.display.Sprite;
		import flash.utils.Timer;
			import flash.events.*;

    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
	public class FractaleTree extends Sprite{
		
		//ブランチの階層
		private const BRACTH:Number = 10;
		//上に向けて木を描く
		private const RADIAN:Number = 270 * Math.PI/180;
		
		//枝分かれのラジアンを計算
		private const angle:uint = 20; 
		private const BRANCH_RADIAN_LEFT:Number = angle * Math.PI/180;
		private const BRANCH_RADIAN_RIGHT:Number = -angle * Math.PI/180;
		
		//始点
		private const treeStartX:Number = 230;
		private const treeStartY:Number = 300; 
		
		//左右
		private const LEFT:uint  = 1;
		private const RIGHT:uint = 2;
		
		private var mySprite:Sprite = new Sprite();

		public function FractaleTree(){
			//幹を描く
			mySprite.graphics.moveTo(230, 465);
			mySprite.graphics.lineStyle(1,0xFFFFFF);
			mySprite.graphics.lineTo(treeStartX, treeStartY);
			this.stage.addChild(mySprite);	
			//枝を描く
			drawTree(BRACTH,treeStartX,treeStartY,RADIAN);
		
                }
		private function drawTree(count:Number,x:Number,y:Number,r:Number):void{
			if(count==0){
				//何もしない
			}else{
				//左に枝を描く
				drawBranch(count,x,y,r,LEFT);
				//右に枝を描く
				drawBranch(count,x,y,r,RIGHT);
			}
		}
		private function drawBranch(count:Number, x:Number, y:Number, r:Number, m:uint):void{
				var nextR:Number = 0;
				if ( m == LEFT ){
					nextR = r + BRANCH_RADIAN_LEFT;
				}else if ( m == RIGHT ){
					nextR = r + BRANCH_RADIAN_RIGHT;
				}else{ //エラー
				}
				var branchX:Number = 0.9 * count * 5.5 * Math.cos(nextR);
				var branchY:Number = 0.9 * count * 5.5 * Math.sin(nextR);
				
				var myTimer:Timer = new Timer(100,8);
				
				var nextX:Number = x;
				var nextY:Number = y;
									
				myTimer.addEventListener(TimerEvent.TIMER,function(event:TimerEvent):void {
					nextX += branchX/8;
					nextY += branchY/8;				
				
					mySprite.graphics.moveTo(x, y);
					mySprite.graphics.lineTo( nextX, nextY);
				});
				myTimer.addEventListener(TimerEvent.TIMER_COMPLETE,function(event:TimerEvent):void{
				//一回層下の枝を描く
				drawTree(count - 1, nextX, nextY, nextR);
				});
				myTimer.start();
		}
		
	}

}
