/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hMKa
 */

package {
    import com.bit101.components.CheckBox;
    import com.bit101.components.HRangeSlider;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.getTimer;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.easing.CircularEaseOut;
    import org.libspark.betweenas3.core.easing.IEasing;
    import org.libspark.betweenas3.core.easing.QuadraticEaseOut;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.SiONDriver;
    import org.si.sound.DrumMachine;

    /**
     * ...
     * @author
     */
    public class Main extends Sprite {
        //property
        private var time:Number = 25;
        private var speed:Number = 0.5;
        private var outerR:Number = 50;
        private var innerR:Number = 16;
        //score
        private var score:int;
        private var outerC:uint;
        private var innerC:uint;
        private var dummyC:uint;
        private var click:uint;
        private var hit:uint;
        private var per:Number;
        //mat
        private var outer:Sprite;
        private var inner:Sprite;
        private var easing:IEasing = new QuadraticEaseOut();
        private var tween:ITween;
        //timer
        private var start:Number;
        private var timer:Sprite;
        private var timerT:ITween;
        private var timerL:Label;
        //menu
        private var menu:Sprite;
        private var veloSlider:HUISlider;
        private var timeSlider:HUISlider;
        private var sound:CheckBox;
        private var exOuter:Sprite;
        private var exInner:Sprite;
        //scoreLabel
        private var shotL:Label;
        private var greatL:Label;
        private var goodL:Label;
        private var hitL:Label;
        private var percentL:Label;
        private var scoreL:Label;
        private var wordL:Label;
        //sion
        private var driver:SiONDriver;
        private var drum:DrumMachine;

        public function Main(){
            //sion
            driver = new SiONDriver();
            driver.setSamplerData(1, driver.render("t200;#A=@v96q0s32l32o7e-crb-;A"));
            driver.setSamplerData(2, driver.render("t200;#A=%1@1@v128p2q0s32l32o5c<fcr<gb-f;k4A;k-4A"));
            driver.setSamplerData(3, driver.render("t200;#A=%1@1@v128p2q0sfcr<gb-f;k4A;k-4A"));
            drum = new DrumMachine();
            driver.bpm = 160;
            //dummy
            var dummy:Sprite = new Sprite();
            _drawRect(dummy.graphics, 0, 0, stage.stageWidth, stage.stageHeight, 0xffffff);
            dummy.addEventListener(MouseEvent.MOUSE_DOWN, _onDummy);
            //timer
            var timerS:Shape = new Shape();
            _drawRect(timerS.graphics, 0, 0, stage.stageWidth, stage.stageHeight, 0xcccccc);
            timerS.x = -stage.stageWidth / 2;
            timerS.y = -stage.stageHeight / 2;
            timer = new Sprite();
            timer.addChild(timerS);
            timer.x = stage.stageWidth / 2;
            timer.y = stage.stageHeight / 2;
            timerL = new Label(timer, 0, -200, "");
            timerL.scaleX = timerL.scaleY = 3;
            timer.addEventListener(MouseEvent.MOUSE_DOWN, _onDummy);
            //mat
            outer = new Sprite();
            inner = new Sprite();
            outer.addChild(inner);
            outer.addEventListener(MouseEvent.MOUSE_DOWN, _onOuter);
            inner.addEventListener(MouseEvent.MOUSE_DOWN, _onInner);
            //menu
            menu = new Sprite();
            _drawRect(menu.graphics, 0, 0, stage.stageWidth, stage.stageHeight, 0xffffff);
            exOuter = new Sprite();
            exInner = new Sprite();
            menu.addChild(exOuter);
            exOuter.addChild(exInner);
            exOuter.x = 100;
            exOuter.y = 100;
            new PushButton(menu, 200, 200, "start", _onStart);
            veloSlider = new HUISlider(menu, 200, 240, "speed");
            veloSlider.setSliderParams(10, 100, 20);
            timeSlider = new HUISlider(menu, 200, 280, "time");
            timeSlider.setSliderParams(2, 100, time);
            sound = new CheckBox(menu, 200, 360, "sound");
            sound.selected = true;
            new Label(menu, 200, 320, "range");
            var range:HRangeSlider = new HRangeSlider(menu, 236, 325);
            range.minimum = 2;
            range.highValue = outerR;
            range.addEventListener(Event.CHANGE, _onRange);
            range.lowValue = innerR;
            //score
            var score:Sprite = new Sprite();
            addChild(score);
            score.addChild(dummy);
            score.addChild(timer);
            score.addChild(outer);
            score.addChild(menu);
            shotL = new Label(score, 10, 360, "shot");
            greatL = new Label(score, 10, 380, "great");
            goodL = new Label(score, 10, 400, "good");
            hitL = new Label(score, 10, 420, "hit");
            percentL = new Label(score, 10, 440, "percent");
            scoreL = new Label(score, 10, 460, "score");
            wordL = new Label(score, 150, 60, "");
            wordL.scaleX = wordL.scaleY = 2;
        }

        //menu

        private function _onRange(e:Event):void {
            outerR = e.currentTarget.highValue;
            innerR = e.currentTarget.lowValue;
            _setTarget(exOuter, exInner);
        }

        private function _onStart(e:MouseEvent):void {
            speed = 10 / veloSlider.value;
            time = timeSlider.value;
            timerT = BetweenAS3.to(timer, {scaleX: 1, scaleY: 1}, time, new CircularEaseOut());
            timerT.onComplete = _onComplete;
            timerT.onUpdate = _onTimer;
            timer.scaleX = timer.scaleY = 0.01;
            timerT.play();
            _setTarget(outer, inner);
            _initGame();
            menu.visible = false;
            if (sound.selected){
                driver.play();
                drum.play();
            }
            start = getTimer();
        }

        //init

        private function _initGame():void {
            score = 0;
            outerC = 0;
            innerC = 0;
            dummyC = 0;
            click = 0;
            per = 0;
            hit = 0;
            _updateText();
            tween = BetweenAS3.to(outer, {x: stage.stageWidth / 2, y: stage.stageHeight / 2}, 0.001);
            tween.play();
        }

        private function _setTarget(outS:Sprite, inS:Sprite):void {
            _drawCircle(outS.graphics, 0, 0, outerR, 0xff0000);
            _drawCircle(inS.graphics, 0, 0, innerR, 0x00ff00);
        }

        //event

        private function _onOuter(e:MouseEvent):void {
            e.stopPropagation();
            tween.stop();
            _tween();
            score += 1;
            outerC++;
            hit++;
            wordL.text = "GOOD";
            _upDate();
            _soundPlay(2);
        }

        private function _onInner(e:MouseEvent):void {
            e.stopPropagation();
            tween.stop();
            _tween();
            score += 2;
            innerC++;
            hit++;
            wordL.text = "GREAT";
            _upDate();
            _soundPlay(1);
        }

        private function _onDummy(e:MouseEvent):void {
            e.stopPropagation();
            score -= 2;
            dummyC++
            wordL.text = "POOR";
            _upDate();
            _soundPlay(3);
        }

        private function _upDate():void {
            click++;
            if (hit != 0){
                per = (hit / click * 100) >> 0;
            } else {
                per = 0;
            }
            _updateText();
        }

        private function _updateText():void {
            shotL.text = "shot : " + click;
            greatL.text = "great : " + innerC;
            goodL.text = "good : " + outerC;
            hitL.text = "hit : " + hit;
            percentL.text = "percent : " + per;
            scoreL.text = "score : " + score;
        }

        //tween

        private function _tween():void {
            var tX:Number = Math.random() * (stage.stageWidth - 2 * outerR) + outerR;
            var tY:Number = Math.random() * (stage.stageHeight - 2 * outerR) + outerR;
            tween = BetweenAS3.to(outer, {x: tX, y: tY}, speed, easing);
            tween.play();
        }

        private function _onComplete():void {
            menu.visible = true;
            wordL.text = "push start";
            if (sound.selected){
                drum.stop();
                driver.stop();
            }
            timerT.removeEventListener(TweenEvent.UPDATE, _onTimer);
        }

        private function _onTimer():void {
            timerL.text = String(time * 1000 + start - getTimer());
        }

        //sound
        private function _soundPlay(index:int):void {
            if (sound.selected){
                var track:SiMMLTrack = driver.playSound(index, 4, 0, 1);
                track.velocity = 96;
            }
        }

        //util
        private function _drawRect(g:Graphics, xpos:Number, yPos:Number, width:Number, height:Number, color:uint):void {
            g.clear();
            g.beginFill(color);
            g.drawRect(xpos, yPos, width, height);
            g.endFill();
        }

        private function _drawCircle(g:Graphics, xpos:Number, yPos:Number, radius:Number, color:uint):void {
            g.clear();
            g.beginFill(color);
            g.drawCircle(xpos, yPos, radius);
            g.endFill();
        }

    }

}