/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hLtU
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    [SWF(frameRate = 60, width = 640, height = 480)]
    public class Main extends Sprite
    {
        public var stageWidth  :Number = 640 ;
        public var stageHeight :Number = 480 ;
        
        public var canvas :BitmapData = new BitmapData((stageWidth - 1), (stageHeight - 2));
        public var node   :Node;
        
        internal var canvasPointer :Bitmap;
        
        //internal var firstPoint   :Point;
       // internal var currentPoint :Point;
       // internal var calcPoint    :Point;
        
        public function Main()
        {    
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _init();
        }
        
        public function _init() :void
        {
            var canvasTemp :Bitmap;
            
            addChild(canvasTemp = new Bitmap(canvas.clone()));
                   
            canvasPointer = canvasTemp;    
            canvasPointer.y = 1;
            
            canvasPointer.bitmapData.setPixel(40, 30, 0);
            canvasPointer.bitmapData.setPixel(42, 30, 0);
            canvasPointer.bitmapData.setPixel(44, 30, 0);
            canvasPointer.bitmapData.setPixel(46, 30, 0);
            canvasPointer.bitmapData.setPixel(46, 32, 0);
            canvasPointer.bitmapData.setPixel(46, 34, 0);
            canvasPointer.bitmapData.setPixel(46, 36, 0);
            canvasPointer.bitmapData.setPixel(44, 36, 0);
            canvasPointer.bitmapData.setPixel(42, 36, 0);
            canvasPointer.bitmapData.setPixel(40, 36, 0);
            canvasPointer.bitmapData.setPixel(40, 34, 0);
            canvasPointer.bitmapData.setPixel(40, 32, 0);
            
            graphics.clear      ();
            graphics.lineStyle  (1, 0);
            graphics.drawRect   (0, 0, (stageWidth - 1), (stageHeight - 1));
            graphics.endFill    ();
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
               
            addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        public function onMouseDown($e:MouseEvent) :void
        {
            //firstPoint = new Point($e.stageX, $e.stageY);

            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
       
        public function onMouseMove($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);   
            
           // currentPoint = new Point($e.stageX, $e.stageY);
           // calcPoint = Point(currentPoint.subtract(firstPoint));
            
           // firstPoint = currentPoint;
        }

        public function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.net.*;

class Node extends Sprite
{
    protected var _x:Number;
    protected var _y:Number;
    protected var _w:Number;
    protected var _h:Number;
    protected var _a:Number;
    protected var _c:Number;
    
    public function Node($x:Number, $y:Number, $a:Number = 0.5, $c:Number = 0)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _a = $a;
        _c = $c;
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, _c, 1);
        graphics.moveTo    (_x, _y);
        graphics.lineTo    (_x, _y);
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
    }
}























