/**
 * Copyright hellolight ( http://wonderfl.net/user/hellolight )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hKnt
 */

// forked from ooolionboyooo's flash on 2010-1-24
// forked from checkmate's Saqoosha challenge for amateurs
/*
 * - - -
 * 画面をクリックすると別のアナライザに変わります
 * VectorにAnalyzer関数を追加するだけで動きます
 * 
 * ※ 別ウィンドウでサウンドを扱うSWFコンテンツを閲覧していると 動きません
 * ※ 音量注意
 */

 package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.utils.*;
    
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.tweens.*;
    import org.libspark.betweenas3.easing.*;
    
    import org.libspark.thread.*;

    [SWF(backgroundColor="#000000", frameRate=120)]
    public class Main extends Sprite {
        private var sound:Sound = new Sound();
        public function Main() {
            if(!Thread.isReady) Thread.initialize(new EnterFrameThreadExecutor());
            Security.loadPolicyFile("http://clockmaker.jp/crossdomain.xml");
            this.addEventListener(Event.ADDED, added);
        }
        
        public function added(e:Event = null):void {
            this.removeEventListener(Event.ADDED, added);
            //clockmakerさん ありがとうございます！
            sound.load(new URLRequest("http://clockmaker.jp/labs/081031_pv3d_visualizer/bin/music.mp3")); 
            //sound.load(new URLRequest("sound/sound.mp3")); 
            sound.addEventListener(Event.COMPLETE, init);
        }
        
        private var ac:AnalyzerController;
        public function init(e:Event = null):void {
            sound.removeEventListener(Event.COMPLETE, init);
            var soundChannel:SoundChannel = sound.play(0, 99);
            
            ac = new AnalyzerController(stage);
            ac.start();
        }
    }
}

import org.libspark.thread.Thread;
import flash.display.*;
import flash.events.*;
class AnalyzerController extends Thread {
    private var _stage:Stage;
    private var bitmap:Bitmap;
    private var bitmapData:BitmapData;
    private var soundSpectrum:SoundSpectrum;
    private var analyzer:Analyzer;
    public function AnalyzerController(stage:Stage):void {
        this._stage = stage;
        analyzer = new Analyzer(stage);
        analyzer.start();
    }
    override protected function run():void {
        event(_stage, MouseEvent.CLICK, myStart);
    }
    private function myStart(e:MouseEvent):void {
        analyzer.changeAnalyzer();
        next(run);
    }
}
import org.libspark.thread.Thread;
import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.media.*;
import flash.geom.*;
import flash.filters.*;
import flash.text.*;
class Analyzer extends Thread {
    private var _stage:Stage;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var ss:SoundSpectrum;
    //private var grad:Gradation = new Gradation(0x555555, 0x44617b, 0x6c848d, 0xb8d200, 0xffd900, 0xdb8449, 0xe45e32, 0xf08300, 0xe83929);
    private var grad:Gradation = new Gradation(0x99ff00, 0x009900, 0x0099cc, 0x0066ff , 0x9933cc, 0xff33ff, 0xff0099, 0xffff00, 0xff6600, 0xff3300);
    private var grad2:Gradation = new Gradation(0x000000, 0xff0000, 0xffffff);
    private var tf:TextField = new TextField();
    private var AV:Vector.<Function>;
    private var playingAnalyzer:uint;
    public function Analyzer(stage:Stage) {
        this._stage = stage;
        ss = new SoundSpectrum(stage);
        ss.start();
        playingAnalyzer = 0;
        bitmapData = new BitmapData(465, 465, false, 0x000000);
        bitmap = _stage.addChild(new Bitmap(bitmapData, PixelSnapping.AUTO, false)) as Bitmap;
        var pointZero:Point = new Point();
        
        AV  = new Vector.<Function>();
        /*
         * 最終的に bitmapData で描画してください
         * SoundSpectrum.dataAll
         * SoundSpectrum.dataVector[i]
         */
        
        AV[4] = function():void {
            var sprite:Sprite = new Sprite();
            var g:Graphics = sprite.graphics;
            g.lineStyle(5, grad.getColor(ss.dataAll / 300));
            g.drawCircle(232.5, 232.5, ss.dataAll >> 1 as int);
            bitmapData.lock();
            bitmapData.applyFilter(bitmapData, bitmapData.rect, pointZero, new BlurFilter());
            bitmapData.draw(sprite);
            bitmapData.unlock();
        };
        AV[5] = function():void {
            var sprite:Sprite = new Sprite();
            var g:Graphics = sprite.graphics;
            for (var i:uint = 0; i < 256; i++) {
                g.lineStyle(1, grad.getColor(i / 256));
                g.moveTo(i << 1, 301);
                g.lineTo(i << 1, ss.dataVector[i]);
            }
            bitmapData.lock();
            bitmapData.applyFilter(bitmapData, bitmapData.rect, pointZero, new BlurFilter(0,36));
            bitmapData.draw(sprite);
            bitmapData.unlock();
        };
        AV[6] = function():void {
            var sprite:Sprite = new Sprite();
            var g:Graphics = sprite.graphics;
            for (var i:uint = 0; i < 100; i++) {
                g.lineStyle(2, grad.getColor(i / 100));
                g.moveTo(8 + i << 2, 301);
                g.lineTo(8 + i << 2, ss.dataVector[i] ^ 2 >> i / i * 1 << 2);
            }
            bitmapData.lock();
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0, 45) , new BlurFilter(0, 81));
            bitmapData.draw(sprite);
            bitmapData.unlock();
        };
        AV[7] = function():void {
            bitmapData.lock();
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0,6), new BlurFilter(0,0));
            for (var i:uint = 0; i < 232; i++) {
                var color:uint = ((ss.dataVector[i] - 300) * -1 * 0xf)/300;
                bitmapData.setPixel(i << 1,  0 , grad2.getColor(color));
                bitmapData.setPixel(i << 1,  1 , grad2.getColor(color));
                bitmapData.setPixel(i << 1,  2 , grad2.getColor(color));
            }
            bitmapData.unlock();
        };
        AV[8] = function():void {
            var sprite:Sprite = new Sprite();
            var g:Graphics = sprite.graphics;
            if (ss.dataVector[100] >50) {
                g.lineStyle(2, grad.getColor(ss.dataAll / 400));
                g.drawCircle(Math.random()*465, (ss.dataAll>>4)*2+10 as int, ss.dataAll >> 4 as int);
            }
            bitmapData.lock();
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(0, 6), new BlurFilter(0, 0));
            bitmapData.draw(sprite);
            bitmapData.unlock();
        };
        
    
    }
    override protected function run():void {
        event(_stage, Event.ENTER_FRAME, analyzerRun);
    }
    private function analyzerRun(e:Event):void {
        AV[playingAnalyzer].call();
        next(run);
    }
    public function changeAnalyzer():void {
        playingAnalyzer  = Math.random() * AV.length;
        return;
    }
}

import org.libspark.thread.Thread;
import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.media.*;
import flash.utils.ByteArray;
import flash.geom.Rectangle;
import flash.events.Event;
import flash.media.SoundMixer;
class SoundSpectrum extends Thread {
    private var _stage:Stage;
    public function SoundSpectrum(stage:Stage):void {
        this._stage = stage;
    }
    override protected function run():void {
        event(_stage, Event.ENTER_FRAME, soundSpectrumRefresh);
    }
    
    public var dataAll:uint;
    public var dataVector:Vector.<Number>;
    private function soundSpectrumRefresh(e:Event):void {
        var bytes: ByteArray = new ByteArray();
        SoundMixer.computeSpectrum(bytes, true, 0);
        
        dataAll = new uint();
        dataVector = new Vector.<Number>();
        
        for( var i: int = 0 ; i < 256 ; i++ ) {
            var value:Number = bytes.readFloat();
            var smooth:Number;
            if( i == 0 ) smooth = value;
            else smooth += ( value - smooth ) / 8;
            var height:Number = smooth * 0xa;
            dataAll += height;
            
            dataVector.push(300 - height * 0xf);
        }
        next(run);
    }
}

import frocessing.color.ColorLerp;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        return (alpha == 0)?_colors[idx]:ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
    }
}