/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hKAn
 */

package {
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private const UNIT:uint = 4;
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _particles:Array = new Array();
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            setBmp();
            setParticles();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function setBmp():void {
            _bmd = new BitmapData(465, 465, true, 0x00ffffff);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
        }

        
        private function setParticles():void {
            var xNum:uint = uint( 465 / UNIT );
            var yNum:uint = uint( 465 / UNIT );
            for(var i:uint = 0; i < xNum; i++){
                for(var j:int = 0; j < yNum; j++){
                    var p:Particle = new Particle();
                    p.x = p.dx = i * UNIT;
                    p.y = p.dy = j * UNIT;
                    _particles.push(p);
                }
            }
        }
        
        private function onEnterFrame(e:Event):void {
            _bmd.lock();
            _bmd.colorTransform( new Rectangle(0, 0, 465, 465), new ColorTransform(0, 0, 0, 0));           
            var pLength:uint = _particles.length;
            var i:int = -1;
            while (i++ < pLength - 1){
                var radian:Number = Math.atan2(_particles[i].dy - mouseY, _particles[i].x - mouseX);
                var distance:Number = Point.distance( new Point(_particles[i].x, _particles[i].y), new Point(mouseX, mouseY) );
                if( distance < 50 ){
                    _particles[i].x = int(mouseX + ( (_particles[i].x + Math.cos(radian) * 60) - mouseX )* _particles[i].a);
                    _particles[i].y = int(mouseY + ( (_particles[i].y + Math.sin(radian) * 60) - mouseY) * _particles[i].a);
                } else {
                    if(Math.abs(_particles[i].dx - _particles[i].x) > 1) {
                        _particles[i].x = int(_particles[i].x + (_particles[i].dx - _particles[i].x) * _particles[i].a);
                    } else {
                        _particles[i].x = _particles[i].dx;
                    }
                    if(Math.abs(_particles[i].dy - _particles[i].y) > 1) {
                        _particles[i].y = int(_particles[i].y + (_particles[i].dy - _particles[i].y) * _particles[i].a);
                    } else {
                        _particles[i].y = _particles[i].dy;
                    }
                    
                }
                _bmd.setPixel32(_particles[i].x, _particles[i].y, 0xffff0000);
            }
            _bmd.unlock();
        }

    }
}

internal class Particle {
    public var dx:Number;
    public var dy:Number;
    public var x:Number;
    public var y:Number;
    public var a:Number;
    public function Particle() {
        dx = 0;
        dy = 0;
        x = 0;
        y = 0;
        a = 0.5;
    }
}
