/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hK8G
 */

package
{
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.utils.Timer;
	
	import frocessing.color.ColorHSV;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x0")]
	public class Mozaiku extends Sprite
	{
		private var _timer:Timer;
		private var _linecount:int = 50;
		private var _lines:Array;
		private var _h:int;
		
		public function Mozaiku()
		{
			Wonderfl.capture_delay( 5 );
			addEventListener(Event.ADDED_TO_STAGE , _init );
		}
		
		private function _init(e:Event):void {
			_createOjisan();
			
			//ウジョウジョ用意
			_lines = [];
			for(var i:Number = 0;i < _linecount;i++ ){
				var s:Shape = new Shape();
				addChild(s);
				s.blendMode = BlendMode.ADD;
				s.x = 465 >>1;
				s.y = 465 >>1;
				_lines.push(s);
			}
			
			_timer = new Timer(70);
			_timer.addEventListener(TimerEvent.TIMER , _update );
			_timer.start();
		}
		
		private function _update(e:TimerEvent = null):void {
			//ウジョウジョ描く
			var color:ColorHSV = new ColorHSV(_h+=10 , 0.7);
			var glow:GlowFilter = new GlowFilter(color.value , 0.8 , 2 ,2 ,1 );
			for(var i:Number = 0;i < _lines.length;i++ ){
				var s:Shape = _lines[i];
				s.filters =  [glow];
				var g:Graphics = s.graphics;
				var ramdom1:Number = Math.random();
				var pt:Point = new Point(Math.cos(ramdom1*Math.PI*2) * 100*ramdom1 , Math.sin(ramdom1*Math.PI*2) * 50*ramdom1)
				g.clear();
				g.lineStyle(1 , 0xFFFFFF , 0.5 );
				g.moveTo( pt.x, pt.y );
				for(var v:Number = 0;v < 80;v++ ){
					pt.x += Math.cos(Math.random()*Math.PI*2) * 16;
					pt.y += Math.sin(Math.random()*Math.PI*2) * 8;
					g.lineTo( pt.x , pt.y );
				}
				g.endFill();
			}
		}
		
		private function _createOjisan():void {
			var s:Shape = new Shape();
			s.x = 170;
			s.y = 230;
			var g:Graphics = s.graphics;
			//輪郭
			g.beginFill( 0x9d7f14 , 1 );
			g.drawRoundRect( 0,0,100 , 300 , 48,48);
			g.endFill();
			//耳
			g.beginFill( 0x9d7f14 , 1 );
			g.drawCircle(0,100,20);
			g.drawCircle(100,100,20);
			g.endFill();
			//目
			g.beginFill( 0x0 , 1 );
			g.drawCircle(20,80,4);
			g.drawCircle(80,80,4);
			g.endFill();
			//口
			g.beginFill( 0x0 , 1 );
			g.drawRoundRect( 40,120,20 , 200 , 48,48);
			g.endFill();
			
			addChild(s);
		}

	}
}