/**
 * Copyright lewis_c1986 ( http://wonderfl.net/user/lewis_c1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hK70
 */

package {
    import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.filters.BitmapFilter;
	import flash.filters.DropShadowFilter;
	import flash.text.TextFormat;
	import flash.text.TextField;
	import flash.text.AntiAliasType;
	import flash.events.MouseEvent;
	import fl.transitions.Tween;
 	import fl.transitions.easing.Strong;
	import fl.transitions.TweenEvent;
	import flash.system.Security;
	import flash.system.SecurityDomain;
	import flash.system.LoaderContext;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.ProgressEvent;

	import flash.text.Font;
	import flash.errors.IOError;
	import flash.net.URLRequestMethod;
	import flash.net.URLLoaderDataFormat;
	import flash.events.DataEvent;
	import flash.events.HTTPStatusEvent;
	public class Main extends Sprite
	{
		private var xml:XML; // The XML Object that will parse the XML File  
		private var images:Array = new Array(); //This array will store the images loaded  
		private var imagesLoaded:int = 0; //A counter, counts the images loaded  
		private var imagesTitle:Array = new Array(); //The title properties of the XML File  
		private var tween:Tween; //Handles the animation  
		private var zoomed:Boolean = false; //Checks if a picture is zoomed, false by default  
		private var canClick:Boolean = true; //Checks if the user can click a picture to zoom it, true by default  
		private var lastX:int; //Stores the x property of the last picture that was clicked  
		private var lastY:int; //Stores the y property of the last picture that was clicked  
		private var textformat:TextFormat = new TextFormat(); //A TextFormat Object  
		private var screen:Sprite = new Sprite(); //A black screen to focus on the active picture
		private var txtSt8us:TextField = new TextField();
		private var preloader:MovieClip = new MovieClip();
		private var circle:Sprite = new Sprite();
		private var angle:Number = 0;	
				
		public function Main()
		{
			// write as3 code here...
			textformat.color = 0x666666;
				textformat.font = "arial";
				textformat.size = 17; //Use the same size you used when embedding the font from the Library   
				screen.graphics.beginFill(0x111111, .75);
				screen.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
				screen.graphics.endFill();
				preloader.addChild(circle);
				preloader.addChild(txtSt8us);
				addChild(preloader);
				txtSt8us.multiline = true;
				preloader.x = (stage.stageWidth / 2) - (preloader.width / 2);
				preloader.y = (stage.stageHeight / 2) - (preloader.height / 2);
				//Security.loadPolicyFile("http://codesign2.com/wonderFL/xml/crossdomain.xml");
				loadXML("images.xml");
		}
		
		private function traceIt(txt:String):void
		{
			txtSt8us.text = txt;
			txtSt8us.autoSize = "center";
		}
		
		private function onProgress(e:ProgressEvent):void {
			angle = Math.round(360 * (e.bytesLoaded / e.bytesTotal));
			angle = angle * Math.PI / 180;
			var newX:Number = (stage.stageWidth/2) + Math.cos(angle) * 50;
			var newY:Number = (stage.stageHeight/2) + Math.sin(angle) * 50;
			if (!isNaN(newY) && !isNaN(newX)){
				circle.graphics.lineTo(newX, newY);
			}
		
      	   traceIt(Math.round((e.bytesLoaded / e.bytesTotal) * 100) + "%");
      	}
		
		private function loadXML(file:String):void  
		{
			var xmlLoader:URLLoader = new URLLoader();
			circle.graphics.clear();
			circle.graphics.lineStyle(1.0, 0x000000);
			circle.graphics.moveTo((stage.stageWidth/2) + 50, (stage.stageHeight/2));		
				var urlReq:URLRequest = new URLRequest(file);
				urlReq.method = URLRequestMethod.GET;
				urlReq.url = file;
				
				xmlLoader = new URLLoader();
				xmlLoader.dataFormat = URLLoaderDataFormat.TEXT;
				
				xmlLoader.addEventListener(ProgressEvent.PROGRESS, onProgress);
				xmlLoader.addEventListener(Event.COMPLETE, handleXML);
		
				try{
					traceIt("Loading...");
					xmlLoader.load(urlReq);
				}
				catch(err:Error){
					traceIt("Error");
				}
		}

		private function handleXML(e:Event):void
		{
			traceIt("Loaded XML!");
			xml = new XML(e.target.data);
			for (var i:int = 0; i < xml.children().length(); i++)  
			{
				traceIt("Adding Image "+i);
				var loader:Loader = new Loader();
				loader.load(new URLRequest(String(xml.children()[i].@src)));
				images.push(loader); //Adds the Loaders to the images Array to gain access to them outside this function
				imagesTitle.push(xml.children()[i].@title); //Adds the title attribute content to the array to use it outside this function
				loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded); //A listener to the function that will be executed when an image is loaded
			}
		}

		private function loaded(e:Event):void
		{
			imagesLoaded++; //Adds one to the imagesLoaded variable
			if (xml.children().length() == imagesLoaded) //When all images are loaded...
			{
				preloader.alpha = 0; //Removes the Preloader MovieClip
				
				prepareImages(); //This function is explained in the next step
			}
		}

		private function prepareImages():void  
		{  
			for (var i:int = 0; i < images.length; i++) //These actions will be applied to all the images loaded so we use a "for" and the "images" array to do that  
			{  
				var container:Sprite = new Sprite(); //A container that will store the image, frame, TextField, TextField background and shadow  
				var frame:Sprite = new Sprite(); //The Frame Sprite  
				var infoArea:Sprite = new Sprite(); //The TextField background  
				var infoField:TextField = new TextField(); //The TextField
		
				frame.graphics.beginFill(0xFFFFFF);
				frame.graphics.drawRect(-20, -20, images[i].width + 40, images[i].height + 80);
				frame.graphics.endFill();

				infoArea.graphics.beginFill(0x111111, 0.75);
				infoArea.graphics.drawRect(0, 0, images[i].width, 60);
				infoArea.graphics.endFill();
				infoArea.y = images[i].height - 60;

				infoField.defaultTextFormat = textformat;
				infoField.embedFonts = true; //You have to add this to use the embedded font
				infoField.antiAliasType = AntiAliasType.ADVANCED; //This property will display the text more clearly
				infoField.width = images[i].width - 5;
				infoField.height = 20;
				infoField.text = imagesTitle[i]; //The content, obtained from the XML and stored in the Array

				container.scaleX = 0.3;
				container.scaleY = 0.3;

				container.x = stage.stageWidth / 4 + Math.floor(Math.random() * (stage.stageWidth / 4));
				container.y = stage.stageHeight / 5 + Math.floor(Math.random() * (stage.stageHeight / 5));

				var shadowFilter:BitmapFilter = new DropShadowFilter(3, 90, 0x252525, 1, 2, 2, 1, 15); //Distance, angle, color, alpha, blur, strength, quality  
				var filterArray:Array = [shadowFilter];  
				container.filters = filterArray; //Apply the filter

				infoArea.addChild(infoField); //Adds the TextField to the TextField Background
				container.addChild(frame); //Adds the Frame to the Container  
				container.addChild(images[i]); //Adds the Image on top of the Frame in the Container  
				infoArea.visible = false; //We set the image information to invisible by default  
				container.addChild(infoArea); //Adds the information area in top of everything 

				container.getChildAt(1).addEventListener(MouseEvent.MOUSE_UP, zoomHandler); //This is the Image loaded by the XML, this is the Loader object
				container.getChildAt(0).addEventListener(MouseEvent.MOUSE_DOWN, dragImage); //This is the Frame  
				container.getChildAt(0).addEventListener(MouseEvent.MOUSE_UP, stopDragImage); //Frame  
				addChild(container); //Lastly, we add the Container to the Stage
			}
		}

		private function dragImage(e:MouseEvent):void
		{
			e.target.parent.startDrag();
		}

		private function stopDragImage(e:MouseEvent):void
		{
			e.target.parent.stopDrag();
		}

		private function zoomHandler(e:MouseEvent):void
		{
			if (! zoomed && canClick) //This variables avoid the common error of clicking multiple times
			{
				canClick = false;
				addChild(screen); //Adds the Black Screen we created in the Constructor

				/* Cant drag when zoomed or zooming */
				e.target.parent.getChildAt(0).removeEventListener(MouseEvent.MOUSE_DOWN, dragImage); //Removes the Listener of the Frame Sprite

				/* Get next highest depth */
				setChildIndex(e.target.parent as Sprite, (numChildren - 1)); //We use the "as" operator because Flash Player takes the target as an Object, not as a Sprite or MC

				/* Get position */
				lastX = e.target.parent.x;
				lastY = e.target.parent.y;

				/* Animation */				
				tween = new Tween(e.target.parent,"scaleX",Strong.easeOut,e.target.parent.scaleX,0.6,0.8,true);
				tween = new Tween(e.target.parent,"scaleY",Strong.easeOut,e.target.parent.scaleY,0.6,0.8,true);

				tween = new Tween(e.target.parent,"x",Strong.easeOut,e.target.parent.x,stage.stageWidth / 2 - e.target.parent.width + 15,0.8,true);
				tween = new Tween(e.target.parent,"y",Strong.easeOut,e.target.parent.y,stage.stageHeight / 2 - e.target.parent.height + 15,0.8,true);

				tween.addEventListener(TweenEvent.MOTION_FINISH, zoomInFinished); //A function to run when the animation is finished
			}
    
			else if (zoomed && canClick) //If the image is zoomed and there's no animation running
			{
				e.target.parent.getChildAt(2).visible = false; //Hides the Information area

				tween = new Tween(e.target.parent,"scaleX",Strong.easeOut,e.target.parent.scaleX,0.3,0.3,true);
				tween = new Tween(e.target.parent,"scaleY",Strong.easeOut,e.target.parent.scaleY,0.3,0.3,true);

				tween = new Tween(e.target.parent,"x",Strong.easeOut,e.target.parent.x,lastX,0.3,true);
				tween = new Tween(e.target.parent,"y",Strong.easeOut,e.target.parent.y,lastY,0.3,true);

				tween.addEventListener(TweenEvent.MOTION_FINISH, zoomOutFinished); //A function to run when the animation is finished
			}
		}

		private function zoomInFinished(e:TweenEvent):void  
		{  
			zoomed = true; //Modify the variables according to the event  
			canClick = true;  
			tween.obj.getChildAt(2).visible = true; //Sets the Information area to visible  
		}  

		private function zoomOutFinished(e:TweenEvent):void
		{  
			zoomed = false;  
			removeChild(screen); //Removes the black screen  
			tween.obj.getChildAt(0).addEventListener(MouseEvent.MOUSE_DOWN, dragImage); //Adds the drag listener back to the Frame Sprite  
		}
	}
}