/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hIwA
 */

// forked from komatsu's PerlinNoiseテスト3 on 2010-2-3
package {
    import flash.filters.BevelFilter;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.BitmapFilterType;
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
        import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.filters.BitmapFilterQuality;
    
    [SWF(backgroundColor="#000000", frameRate=30)]
    
    public class DispMapTest extends Sprite {
            private const STW:uint = stage.stageWidth;
            private const STH:uint = stage.stageHeight;
            private var sp:Sprite;
            private var map:BitmapData;
            private var bm:Bitmap;
            private var offset:Array = new Array();
            private var noiseSeed:Number = 0;
            private var channels:uint = BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN;
        private var blur:BlurFilter;
        private var point1:Point = new Point(0, 0);
        private var point2:Point = new Point(0, 0);
        private var perlinOffset:Array = [point1, point2];
        
        public function DispMapTest() {
             map= new BitmapData(STW, STH, true, 0x00000000);
            bm = new Bitmap(map);
            addChild(bm);
            
            //四角
            sp = new Sprite();
            sp.graphics.beginFill(0x0066FF, 1);
            sp.graphics.drawCircle(STW/2,STH/2,STW/2);
            bm.mask = sp;
            
            var pnt:Point = new Point(0,0);

            
            var ch:uint = BitmapDataChannel.RED;
            var dispFilter:DisplacementMapFilter = new DisplacementMapFilter(map,pnt,ch,ch);
            dispFilter.scaleX =3;
            dispFilter.scaleY =3;
            
            blur = new BlurFilter();
            blur.blurX = 10;
            blur.blurY = 10;
            blur.quality = BitmapFilterQuality.MEDIUM;
            
            var bevelFilter:BevelFilter = getBitmapFilter();

            var filterTimer:Timer = new Timer(40);
            filterTimer.addEventListener(TimerEvent.TIMER , filterTimerFunc);
            function filterTimerFunc(evtObj:TimerEvent):void{
                perlinOffset[0].x -= 10;
                perlinOffset[1].x += 10;
                perlinOffset[0].y += 10;
                perlinOffset[1].y += 10;
                map.perlinNoise(100,100, 1, 1, false, true, channels,true, perlinOffset);
                bm.filters = new Array(dispFilter,blur,bevelFilter,blur);
            }
            filterTimer.start();
        }
        
        private function getBitmapFilter():BevelFilter {
            var distance:Number       = 100;
            var angleInDegrees:Number = 45;
            var highlightColor:Number = 0xFFFFFF;
            var highlightAlpha:Number = 0.8;
            var shadowColor:Number    = 0x000000;
            var shadowAlpha:Number    = 0.8;
            var blurX:Number          = 100;
            var blurY:Number          = 100;
            var strength:Number       = 1;
            var quality:Number        = BitmapFilterQuality.LOW;
            var type:String           = BitmapFilterType.FULL;
            var knockout:Boolean      = true;

            return new BevelFilter(distance,
                                   angleInDegrees,
                                   highlightColor,
                                   highlightAlpha,
                                   shadowColor,
                                   shadowAlpha,
                                   blurX,
                                   blurY,
                                   strength,
                                   quality,
                                   type,
                                   knockout);
        }
    }
}
