/**
 * Copyright Caiim. ( http://wonderfl.net/user/Caiim. )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hIRV
 */


package {
    import flash.filters.BlurFilter;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    
    [SWF(width=500,height=500,backgroundColor=0x000000,frameRate=30)]
    
    public class FlashTest extends Sprite {
        
        private var size:int = 30;
        private var sw:int = stage.stageWidth;
        private var sh:int = stage.stageHeight;
        private var line_mc:MovieClip = null;
        private var lineG:Graphics = null;
        private var blurFilter:BlurFilter = new BlurFilter(2, 2, 3);
        private var hold_mc:MovieClip = new MovieClip();
        
        
        // how many level the ball will split
        private var MAX_LEVEL:int = 3;
        // how many ball will appear when it split ( childNum * current level)
        private var childNum:int = 2;
        
        private var txt:TextField;
        private var textFormat:TextFormat = new TextFormat(null, 20, 0xffffff);
        
        
        public function FlashTest() {
            
            // line_mc is where the lines is drawn
            line_mc = new MovieClip();
            lineG = line_mc.graphics;
            addChild(line_mc);
            stage.addEventListener(MouseEvent.CLICK, spawnCircle);
            
            addChild(hold_mc);
            
            
            // textfield
            txt = new TextField();
            txt.text = "Child : "+childNum+" (alt+click to change)";
            txt.width = sw;
            txt.selectable = false;
            txt.setTextFormat(textFormat);
            addChild(txt);
            
            
            
        }

        
        
        private function spawnCircle(e:MouseEvent):void
        {
            // shange the number of child
            if(e.altKey)
            {
                childNum = (childNum==2)?3:2;
                txt.text = "Child : "+childNum+" (alt+click to change)";
                txt.setTextFormat(textFormat);
            }
            // to spawn the ball
            else
            {
                var _mc:MovieClip = createCircle(sw/2, sh/2, size);
                _mc.level = 1;
                _mc.x = mouseX;
                _mc.y = mouseY;
                _mc.filters = [blurFilter];
                split(_mc);
                hold_mc.addChild(_mc);
            }
        }

        // this will split the ball
        private function split(_mc:MovieClip):void
        {
            if(_mc.level<=MAX_LEVEL)
            {
                var amount:int = _mc.level*childNum;
                for(var i:int =0;i<amount;i++)
                {
                    var _mc2:MovieClip = createCircle(_mc.x, _mc.y, _mc.size*0.60);
                    _mc2.level = _mc.level+1;
                    _mc2.pow = _mc.size*1.5;
                    _mc2.ang = 2*Math.PI*i/amount;//Math.random()*360;
                    _mc2.addEventListener(Event.ENTER_FRAME, move);
                    _mc2.parentPos = new Point(_mc.x, _mc.y);
                    _mc2.filters = [blurFilter];
                    hold_mc.addChild(_mc2);
                }
            }
            _mc.addEventListener(Event.ENTER_FRAME, shrink);
        }
        
        // this moved the ball
        private function move(e:Event):void
        {
            var _mc:MovieClip = MovieClip(e.target);
            _mc.x+=Math.sin(_mc.ang)*_mc.pow;
            _mc.y+=Math.cos(_mc.ang)*_mc.pow;
            _mc.ang++;//=_mc.pow;
            _mc.pow *= 0.8;
            
            if(_mc.pow<1)
            {
               _mc.removeEventListener(Event.ENTER_FRAME, move);
               split(_mc);
               lineG.lineStyle(_mc.size/4, 0x222222);
               lineG.moveTo(_mc.parentPos.x, _mc.parentPos.y);
               lineG.lineTo(_mc.x, _mc.y);
            }

        }
        
        // this will shrink the ball until really small, then removed from stage
        private function shrink(e:Event):void
        {
            var _mc:MovieClip = MovieClip(e.target);
            _mc.width *= 0.9;
            _mc.height *= 0.9;
            if(_mc.width<1)
            {
                  hold_mc.removeChild(_mc);
                  _mc.removeEventListener(Event.ENTER_FRAME, shrink);
            }

        }
        
        // this will create an circle movieclip
        private function createCircle( X:int, Y:int, s:Number):MovieClip
        {
            var _mc:MovieClip = new MovieClip();
            _mc.size = s;
            _mc.x = X;
            _mc.y = Y;
            _mc.graphics.beginFill(Math.random()*0xffffff, 0.8);
           _mc.graphics.drawCircle(-s/2, -s/2, s);
           _mc.graphics.endFill();
           return _mc;
        }

    }
}