/**
 * Copyright elbib ( http://wonderfl.net/user/elbib )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hHvt
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;

    public class GesturePixelsChange extends Sprite 
    {
        private var _camera:Camera;
        private var _video:Video;
        // 1/4 분기 화면
        private var _screen1:Bitmap;
        private var _video1:BitmapData;
        // 2/4 분기 화면
        private var _mergeScreen:Sprite;
        private var _screen2:Bitmap;
        private var _video2:BitmapData;
        private var _ovelap:Bitmap;
        private var _ovelapData:BitmapData;
        // 3/4 분기 화면
        private var _effectScreenData:BitmapData;
        private var _effectScreen:Bitmap;
        // 4/4 분기 화면
        private var _composeScreen:Bitmap; 
        private var _composeScreenData:BitmapData;
        
        private var _cmf:ColorMatrixFilter;
        private var _blr:BlurFilter;
        private var _mtx:Matrix;
        private var _point:Point;
        
        private var _old:BitmapData;
        private var _now:BitmapData;
        private var _camW:int;
        private var _camH:int;

        public function GesturePixelsChange()
        {
            if ( !stage )
                addEventListener( Event.ADDED_TO_STAGE, onAddToStage );
            else
                onAddToStage();
        }
        
        private function onAddToStage(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAddToStage);
            
            /** 최초 멤버 초기 셋팅 */
            _camW = 460;
            _camH = 320;
            _cmf = new ColorMatrixFilter([1,0,0,0,0, 0,1,0,0,0, 0,0,1,0,0, 0,0,0,1,0]);
            _blr = new BlurFilter(2, 2, 2);
            _point = new Point();
            
            /** 화면을 뒤집는 Mirror 효과 */
            _mtx = new Matrix();
            _mtx.translate(-_camW, 0); 
            _mtx.scale( -1, 1);
            
            /** 웹 캠 셋팅 */
            var idx:int = 0;
            var i:int = 0;
            for (; i < Camera.names.length ; i++ ) 
                if ( Camera.names[ i ] == "USB Video Class Video" ) idx = i;
                
            _camera = Camera.getCamera( String( idx ) );
            if (!_camera) throw new Error('No webcam!!!!');
            
            _camera.setMode(_camW, _camH, 30);
            _video = new Video(_camW, _camH);
            _video.attachCamera(_camera);
            
            /** 1/4 분기 화면 - 기본 화면 표현 */
            _video1 = new BitmapData(_camW, _camH, false, 0);
            _screen1 = new Bitmap(_video1);
            _screen1.x = 10;
            _screen1.y = 10;
            addChild(_screen1);

            /** 2/4 분기 화면 - 이전과 현재의 색상 차이 값 표현 */
            _mergeScreen = new Sprite;
            _mergeScreen.x = _camW + 20;
            _mergeScreen.y = 10;
            addChild(_mergeScreen);

            _video2 = new BitmapData(_camW, _camH, false, 0);
            _screen2 = new Bitmap(_video2);
            _mergeScreen.addChild(_screen2);

            _ovelapData = new BitmapData(_camW, _camH, false, 0);
            _ovelap = new Bitmap(_ovelapData);
            _ovelap.blendMode = BlendMode.SUBTRACT;
            _mergeScreen.addChild(_ovelap);

            /** 3/4 분기 화면 - 변화된 픽셀의 값에 컬러 효과 표현 */
            _effectScreenData = new BitmapData(_camW, _camH, false, 0);
            _effectScreen = new Bitmap(_effectScreenData);
            _effectScreen.x = 10 ;
            _effectScreen.y = _camH + 20;
            addChild(_effectScreen);

            /** 4/4 분기 화면 - 1/4분기와 3/4분기의 합성 효과 표현 */
            _composeScreenData = new BitmapData(_camW, _camH, false, 0);
            _composeScreen = new Bitmap(_composeScreenData, "auto", true);
            _composeScreen.x = _camW + 20;
            _composeScreen.y = _camH + 20;
            addChild(_composeScreen);
            
            _now = new BitmapData(_camW, _camH, false, 0);
            _old = new BitmapData(_camW, _camH, false, 0);
            
            /** 화면 렌더링 */
            this.addEventListener(Event.ENTER_FRAME, onRender, false, 0, true);
        }
        
        private function onRender(e:Event = null) : void
        {
            /** 1/4 분기 화면을 Mirror 효과로 적용한다. */
            _video1.draw(_video, _mtx);
            /** 2/4 분기 화면에 현재 화면을 그린다. */
            _ovelapData.draw(_video1);
            /** 2/4 분기 화면에 이전 화면을 그린다. */
            _video2.draw(_old);
            
            /** 4/4 분기 화면을 그린다. */
            _composeScreenData.draw(_video1);
            
            /** 3/4 분기 화면에 필터 효과를 적용하여 컬러 효과를 만들어 낸다. */
            _effectScreenData.applyFilter(_effectScreenData, _effectScreenData.rect, _point, _cmf);
            _effectScreenData.applyFilter(_effectScreenData, _effectScreenData.rect, _point, _blr);
            _effectScreenData.draw(_mergeScreen, null, null, BlendMode.LIGHTEN);
            
            /** 4/4 분기에 3/4 분기 화면을 밝게 처리하여 다시 그린다. */
            _composeScreenData.draw(_effectScreenData, null, null, BlendMode.ADD);
            
            /** 현재 화면은 이전 화면으로 저장해 둔다. */
            _old.draw(_video1);
        }
    }
}
