/**
 * Copyright dotf ( http://wonderfl.net/user/dotf )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hHeF
 */

// forked from flern's flash on 2009-11-3
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.filters.BitmapFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    
    public class DisplacementMapFilterExample extends Sprite {
        private var bgColor:uint     = 0x80FF00;
        private var size:uint        = 200;
        private var offset:uint      = 90;
        private var labelText:String = "Watch the text bend with the displacement map";

        public function DisplacementMapFilterExample() {
            var bitmapData:BitmapData = new BitmapData(size, size, false, bgColor);
            var bitmap:Bitmap = new Bitmap(bitmapData);
            var rect:Rectangle = new Rectangle(size/2 - 20, size/2 - 20, 40, 40);
            bitmapData.draw(this, new Matrix());
            bitmapData.fillRect(rect, 0x0000FF);

            var cloneData:BitmapData = bitmapData.clone();      
            var bitmapClone:Bitmap = new Bitmap(cloneData);
            bitmapClone.x = 200;
            addChild(bitmapClone);
            bitmap.filters = new Array(getBitmapFilter());
            addChild(bitmap);      
            
            
               draw();
            createLabel();
            createFilter();
        }

        private function createFilter():void {
            var filter:BitmapFilter = getBitmapFilter();
            filters = new Array(filter);
        }

        private function getBitmapFilter():BitmapFilter {
            var mapBitmap:BitmapData = createBitmapData();
            var mapPoint:Point       = new Point(0, 0);
            var channels:uint        = BitmapDataChannel.BLUE;
            var componentX:uint      = channels;
            var componentY:uint      = channels;
            var scaleX:Number        = 0;
            var scaleY:Number        = 80;
            var mode:String          = DisplacementMapFilterMode.WRAP;
            var color:uint           = 0xFF0000;
            var alpha:Number         = 1.0;
            return new DisplacementMapFilter(mapBitmap,
                                             mapPoint,
                                             componentX,
                                             componentY,
                                             scaleX,
                                             scaleY,
                                             mode,
                                             color,
                                             alpha);
        }

        private function draw():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(size, size);
//            graphics.beginFill(0xFF0000);
          //  graphics.beginGradientFill(GradientType.RADIAL,
          //                             [0xFF0000, 0x0000FF],
          //                             [100, 100],
          //                             [55, 200],
          //                             matrix,
          //                             SpreadMethod.PAD);
            graphics.drawRect(0, 0, size, size);
        }

        private function createBitmapData():BitmapData {
            var bitmapData:BitmapData = new BitmapData(size, size, false, bgColor);
            bitmapData.draw(this, new Matrix());
            var bitmap:Bitmap = new Bitmap(bitmapData);
            return bitmapData;
        }

        private function createLabel():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(size, size);
            graphics.beginFill(0xFF0000);
            graphics.beginGradientFill(GradientType.RADIAL,
                                       [0xFF0000, 0x0000FF],
                                       [100, 100],
                                       [55, 200],
                                      matrix,
                                      SpreadMethod.PAD);
            graphics.drawRect(0, 0, size, size);

          //  var tf:TextField = new TextField();
          //  tf.text = labelText;
          //  tf.y = offset;
          //  tf.width = size;
          //  addChild(tf);
        }
    }
}