/**
 * Copyright h.bieganowski ( http://wonderfl.net/user/h.bieganowski )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hGw3
 */

// forked from zob's soundSpectrumGalaxy
package
{
    import flash.display.*;
    import flash.filters.*;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.system.*;
    import flash.ui.*;
    import flash.media.*;
    
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    public class galaxy extends Sprite
    {
        // data
        public var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var bmp:Bitmap = new Bitmap(bmpd);
        
        // objects
        private var stars:Vector.<Dot> = new Vector.<Dot>();
        private var SPF:int = 10; // Star Per Frame
        private var damp:Number = 0.3;
        private var speed:Number = 0.5;
        private var focalLength:Number = 1000;
        private var ct:ColorTransform =  new ColorTransform(1,1,1,0.6);
        private var cp:Dot = new Dot(stage.stageWidth/2, stage.stageHeight/2);
        private var snd:Sound;
        private var FFTswitch:Boolean = false;
        private var bytes:ByteArray = new ByteArray();
        private var byteTotal:Number = 0;
        
        public function galaxy()
        {
            
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)));
            addChild(bmp);
            bmpd.fillRect(bmpd.rect, 0x0);
            
            init();
        }
        
        private function init():void
        {
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(1,true);
            var req:URLRequest = new URLRequest(sndUrl);
            var sndChannel:SoundChannel=new SoundChannel();
            snd.load(req, context);
            sndChannel = snd.play(0, 9999);
        }
        
        private function processing(e:Event):void
        {
            update();
            paint();
        }
        
        private function update():void
        {
            var i:int = 0;
            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
            
            byteTotal = 0;
            for(i = 0; i < 512; i++)
            {
                byteTotal += Math.abs(bytes.readFloat());
            }
            byteTotal /= 512;
            speed = 0.5 + 10 * byteTotal;
            
            for(i = 0; i < 10; i++)
            {
                stars.push(new Dot(100 + Math.random() * 265, 100 + Math.random() * 265, 0));
            }
            
            for(i = 0; i < stars.length; i++)
            {
                stars[i].oz = stars[i].z;
                stars[i].vz += speed;
                stars[i].vz *= damp;
                stars[i].z -= stars[i].vz;
            }
        }
        
        private function paint():void
        {
            bmpd.lock();
            bmpd.colorTransform(bmpd.rect, ct);
            
            var i:int = 0;
            var scaleRatio:Number = 0;
            var px:Number = 0;
            var py:Number = 0;
            var ox:Number = 0;
            var oy:Number = 0;
            for(i = 0; i < stars.length; i++)
            {
                scaleRatio = focalLength/(focalLength + stars[i].z);
                px = (stars[i].x - cp.x) * scaleRatio + cp.x;
                py = (stars[i].y - cp.y) * scaleRatio + cp.y;
                
                if(px > stage.stageWidth || px < 0 || py < 0 || py > stage.stageHeight)
                {
                    stars.splice(i, 1);
                    i--;
                } else {
                    scaleRatio = focalLength/(focalLength + stars[i].oz);
                    ox = (stars[i].x - cp.x) * scaleRatio + cp.x;
                    oy = (stars[i].y - cp.y) * scaleRatio + cp.y;
                    
                    lineFast(bmpd, int(px), int(py), int(ox), int(oy), 0xFFFFFFFF);
                }
            }
            
            bmpd.unlock();
        }
        
        public function lineFast(target:BitmapData, x0:int, y0:int, x1:int, y1:int, color:uint):void
        {    
            var pix      :uint = color;
            var dy       :int = y1 - y0;
            var dx       :int = x1 - x0;
            var stepx    :int;
            var stepy    :int;
            var fraction :int;
            
            if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
            if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }
            dy <<= 1;
            dx <<= 1;
            target.setPixel32(x0, y0, pix);
            if (dx > dy)
            {
                fraction = dy - (dx >> 1);
                while (x0 != x1)
                {
                    if (fraction >= 0)
                    {
                        y0 += stepy;
                        fraction -= dx;
                    }
                    x0 += stepx;
                    fraction += dy;
                    target.setPixel32(x0, y0, pix);
                }
            } else {
                fraction = dx - (dy >> 1);
                while (y0 != y1)
                {
                    if (fraction >= 0)
                    {
                        x0 += stepx;
                        fraction -= dy;
                    }
                    y0 += stepy;
                    fraction += dx;
                    target.setPixel32(x0, y0, pix);
                }
            }
        }
    }
}

class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var oz:Number = 0; 
    
    public function Dot(px:Number=0,py:Number=0, pz:Number=0)
    {
        x = px;
        y = py;
        z = pz;
    }
}